/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.common.JournalRuntimeException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.net.ha.ClusterStatusListener;
import com.questdb.net.ha.JournalClient;
import com.questdb.net.ha.JournalServer;
import com.questdb.net.ha.config.ClientConfig;
import com.questdb.net.ha.config.ServerConfig;
import com.questdb.net.ha.config.ServerNode;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.Factory;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClusterController {
    private final Log LOG = LogFactory.getLog(ClusterController.class);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ClusterStatusListener listener;
    private final Factory factory;
    private final List<JournalWriter> writers;
    private final ServerConfig serverConfig;
    private final ClientConfig clientConfig;
    private final ServerNode thisNode;
    private final ClusterStatusListener statusListener = new StatusListener();
    private final ClientCallback clientCallback = new ClientCallback();
    private JournalClient client;
    private JournalServer server;

    public ClusterController(ServerConfig serverConfig, ClientConfig clientConfig, Factory factory, int instance, List<JournalWriter> writers, ClusterStatusListener listener) {
        this.serverConfig = serverConfig;
        this.clientConfig = clientConfig;
        this.factory = factory;
        this.writers = writers;
        this.listener = listener;
        this.thisNode = serverConfig.getNodeByUID(instance);
        if (this.thisNode == null) {
            throw new JournalRuntimeException("Instance " + instance + " is not found in server config", new Object[0]);
        }
    }

    public void halt() {
        if (this.running.compareAndSet(true, false)) {
            this.haltClient();
            if (this.server != null) {
                this.server.halt();
            }
            if (this.listener != null) {
                this.listener.onShutdown();
            }
        }
    }

    public boolean isLeader() {
        return this.server != null && this.server.isLeader();
    }

    public void start() throws JournalNetworkException {
        if (this.running.compareAndSet(false, true)) {
            this.server = new JournalServer(this.serverConfig, this.factory, null, this.thisNode.getId());
            int k = this.writers.size();
            for (int i = 0; i < k; ++i) {
                this.server.publish(this.writers.get(i));
            }
            this.server.start();
            this.server.joinCluster(this.statusListener);
        }
    }

    private void haltClient() {
        if (this.client != null) {
            this.client.halt();
            this.client = null;
        }
    }

    private class ClientCallback
    implements JournalClient.Callback {
        private ClientCallback() {
        }

        @Override
        public void onEvent(int evt) {
            switch (evt) {
                case 4: 
                case 8: 
                case 16: 
                case 64: {
                    ClusterController.this.halt();
                    break;
                }
                case 1: {
                    if (!ClusterController.this.running.get()) break;
                    ClusterController.this.server.joinCluster(ClusterController.this.statusListener);
                    break;
                }
            }
        }
    }

    private class StatusListener
    implements ClusterStatusListener {
        private int lastActive = -1;

        private StatusListener() {
        }

        @Override
        public void goActive() {
            if (ClusterController.this.listener != null) {
                ClusterController.this.listener.goActive();
            }
        }

        @Override
        public void goPassive(ServerNode activeNode) {
            if (activeNode.getId() != this.lastActive) {
                this.lastActive = activeNode.getId();
                ClusterController.this.haltClient();
                ClusterController.this.clientConfig.clearNodes();
                ClusterController.this.clientConfig.addNode(activeNode);
                ClusterController.this.client = new JournalClient(ClusterController.this.clientConfig, ClusterController.this.factory, null, ClusterController.this.clientCallback);
                ClusterController.this.LOG.info().$(ClusterController.this.thisNode.toString()).$(" Subscribing journals").$();
                int sz = ClusterController.this.writers.size();
                for (int i = 0; i < sz; ++i) {
                    JournalWriter w = (JournalWriter)ClusterController.this.writers.get(i);
                    ClusterController.this.client.subscribe(w.getMetadata().getKey(), w, null);
                }
                ClusterController.this.client.start();
                if (ClusterController.this.listener != null) {
                    ClusterController.this.listener.goPassive(activeNode);
                }
            }
        }

        @Override
        public void onShutdown() {
        }
    }
}

