/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.common.JournalRuntimeException;
import com.questdb.ex.IncompatibleJournalException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.mp.MPSequence;
import com.questdb.mp.RingQueue;
import com.questdb.mp.SCSequence;
import com.questdb.mp.Sequence;
import com.questdb.net.SecureSocketChannel;
import com.questdb.net.SslConfig;
import com.questdb.net.StatsCollectingReadableByteChannel;
import com.questdb.net.ha.auth.AuthenticationConfigException;
import com.questdb.net.ha.auth.AuthenticationProviderException;
import com.questdb.net.ha.auth.CredentialProvider;
import com.questdb.net.ha.auth.UnauthorizedException;
import com.questdb.net.ha.comsumer.HugeBufferConsumer;
import com.questdb.net.ha.comsumer.JournalDeltaConsumer;
import com.questdb.net.ha.config.ClientConfig;
import com.questdb.net.ha.model.IndexedJournal;
import com.questdb.net.ha.model.IndexedJournalKey;
import com.questdb.net.ha.producer.JournalClientStateProducer;
import com.questdb.net.ha.protocol.CommandConsumer;
import com.questdb.net.ha.protocol.CommandProducer;
import com.questdb.net.ha.protocol.commands.ByteArrayResponseProducer;
import com.questdb.net.ha.protocol.commands.CharSequenceResponseConsumer;
import com.questdb.net.ha.protocol.commands.IntResponseConsumer;
import com.questdb.net.ha.protocol.commands.IntResponseProducer;
import com.questdb.net.ha.protocol.commands.SetKeyRequestProducer;
import com.questdb.std.CharSequenceHashSet;
import com.questdb.std.Chars;
import com.questdb.std.Files;
import com.questdb.std.IntList;
import com.questdb.std.ObjList;
import com.questdb.std.ObjectFactory;
import com.questdb.std.ex.JournalException;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.store.JournalKey;
import com.questdb.store.JournalListener;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.WriterFactory;
import com.questdb.store.factory.configuration.JournalMetadata;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class JournalClient {
    public static final int MSG_SUBSCRIBE = 0;
    public static final int MSG_HALT = 1;
    public static final int MSG_UNSUBSCRIBE = 2;
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final Log LOG = LogFactory.getLog(JournalClient.class);
    private final ObjList<JournalWriter> writers = new ObjList();
    private final ObjList<JournalWriter> writersToClose = new ObjList();
    private final ObjList<JournalDeltaConsumer> deltaConsumers = new ObjList();
    private final IntList statusSentList = new IntList();
    private final CharSequenceHashSet subscribedJournals = new CharSequenceHashSet();
    private final WriterFactory factory;
    private final CommandProducer commandProducer = new CommandProducer();
    private final CommandConsumer commandConsumer = new CommandConsumer();
    private final ObjList<SubscriptionHolder> subscriptions = new ObjList();
    private final SetKeyRequestProducer setKeyRequestProducer = new SetKeyRequestProducer();
    private final CharSequenceResponseConsumer charSequenceResponseConsumer = new CharSequenceResponseConsumer();
    private final JournalClientStateProducer journalClientStateProducer = new JournalClientStateProducer();
    private final IntResponseConsumer intResponseConsumer = new IntResponseConsumer();
    private final IntResponseProducer intResponseProducer = new IntResponseProducer();
    private final ByteArrayResponseProducer byteArrayResponseProducer = new ByteArrayResponseProducer();
    private final ClientConfig config;
    private final CredentialProvider credentialProvider;
    private final RingQueue<SubscriptionHolder> subscriptionQueue = new RingQueue(SubscriptionHolder.access$000(), 64);
    private final Sequence subscriptionPubSequence = new MPSequence(this.subscriptionQueue.getCapacity());
    private final Sequence subscriptionSubSequence = new SCSequence();
    private final CountDownLatch haltLatch = new CountDownLatch(1);
    private final Callback callback;
    private ByteChannel channel;
    private StatsCollectingReadableByteChannel statsChannel;
    private volatile boolean running = false;

    public JournalClient(WriterFactory factory) {
        this(factory, null);
    }

    public JournalClient(WriterFactory factory, CredentialProvider credentialProvider) {
        this(new ClientConfig(), factory, credentialProvider, null);
    }

    public JournalClient(ClientConfig config, WriterFactory factory) {
        this(config, factory, null, null);
    }

    public JournalClient(ClientConfig config, WriterFactory factory, CredentialProvider credentialProvider) {
        this(config, factory, credentialProvider, null);
    }

    public JournalClient(ClientConfig config, WriterFactory factory, CredentialProvider credentialProvider, Callback callback) {
        this.config = config;
        this.factory = factory;
        this.credentialProvider = credentialProvider;
        this.callback = callback;
        this.subscriptionPubSequence.then(this.subscriptionSubSequence).then(this.subscriptionPubSequence);
    }

    public void halt() {
        long cursor = this.subscriptionPubSequence.next();
        if (cursor < 0L) {
            throw new JournalRuntimeException("start client before subscribing", new Object[0]);
        }
        SubscriptionHolder h = this.subscriptionQueue.get(cursor);
        h.type = 1;
        this.subscriptionPubSequence.done(cursor);
        try {
            if (!this.haltLatch.await(5L, TimeUnit.SECONDS)) {
                this.closeChannel();
            }
        }
        catch (InterruptedException e) {
            LOG.error().$("Got interrupted while halting journal client").$();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        new Handler().start();
    }

    public <T> void subscribe(Class<T> clazz) {
        this.subscribe(clazz, (JournalListener)null);
    }

    public <T> void subscribe(Class<T> clazz, String location) {
        this.subscribe(clazz, location, (JournalListener)null);
    }

    public <T> void subscribe(Class<T> clazz, String remote, String local) {
        this.subscribe(clazz, remote, local, null);
    }

    public <T> void subscribe(Class<T> clazz, String remote, String local, JournalListener journalListener) {
        this.subscribe(new JournalKey<T>(clazz, remote), new JournalKey<T>(clazz, local), journalListener);
    }

    public <T> void subscribe(Class<T> clazz, String remote, String local, int recordHint) {
        this.subscribe(clazz, remote, local, recordHint, null);
    }

    public <T> void subscribe(Class<T> clazz, String remote, String local, int recordHint, JournalListener journalListener) {
        this.subscribe(new JournalKey<T>(clazz, remote, 4, recordHint), new JournalKey<T>(clazz, local, 4, recordHint), journalListener);
    }

    public <T> void subscribe(JournalKey<T> remoteKey, JournalWriter<T> writer, JournalListener journalListener) {
        this.subscribe(remoteKey, writer.getMetadata().getKey(), journalListener, writer);
    }

    public void subscribe(JournalKey remote, JournalKey local, JournalListener journalListener) {
        this.subscribe(remote, local, journalListener, null);
    }

    private void checkAck() throws JournalNetworkException {
        this.charSequenceResponseConsumer.read(this.channel);
        CharSequence value = (CharSequence)this.charSequenceResponseConsumer.getValue();
        this.fail(Chars.equals((CharSequence)"OK", value), value);
    }

    private void checkAuthAndSendCredential() throws JournalNetworkException, AuthenticationProviderException, UnauthorizedException, AuthenticationConfigException {
        this.commandProducer.write(this.channel, (byte)9);
        CharSequence cs = this.readString();
        if (Chars.equals((CharSequence)"AUTH", cs)) {
            if (this.credentialProvider == null) {
                throw new AuthenticationConfigException();
            }
            this.commandProducer.write(this.channel, (byte)10);
            this.byteArrayResponseProducer.write(this.channel, this.getToken());
            CharSequence response = this.readString();
            if (!Chars.equals((CharSequence)"OK", response)) {
                LOG.error().$(response).$();
                throw new UnauthorizedException();
            }
        } else if (!Chars.equals((CharSequence)"OK", cs)) {
            this.fail(true, "Unknown server response");
        }
    }

    private void close0() {
        int i;
        int sz = this.writersToClose.size();
        for (i = 0; i < sz; ++i) {
            this.writersToClose.getQuick(i).close();
        }
        this.writersToClose.clear();
        this.writers.clear();
        int k = this.deltaConsumers.size();
        for (i = 0; i < k; ++i) {
            this.deltaConsumers.getQuick(i).free();
        }
        this.deltaConsumers.clear();
        this.commandConsumer.free();
        this.charSequenceResponseConsumer.free();
        this.intResponseConsumer.free();
        this.statusSentList.clear();
    }

    private void closeChannel() {
        if (this.channel != null && this.channel.isOpen()) {
            try {
                this.channel.close();
            }
            catch (Throwable e) {
                LOG.error().$("Error closing channel").$(e).$();
            }
        }
    }

    private void fail(boolean condition, CharSequence message) throws JournalNetworkException {
        if (!condition) {
            throw new JournalNetworkException(message.toString());
        }
    }

    private byte[] getToken() throws AuthenticationProviderException {
        try {
            return this.credentialProvider.createToken();
        }
        catch (Throwable e) {
            LOG.error().$("Error in credential provider: ").$(e).$();
            throw new AuthenticationProviderException();
        }
    }

    private void notifyCallback(int event) {
        if (this.callback != null) {
            this.callback.onEvent(event);
        }
    }

    private void openChannel() throws JournalNetworkException {
        if (this.channel == null || !this.channel.isOpen()) {
            SocketChannel channel = this.config.openSocketChannel();
            try {
                this.statsChannel = new StatsCollectingReadableByteChannel(channel.getRemoteAddress());
            }
            catch (IOException e) {
                throw new JournalNetworkException("Cannot get remote address", e);
            }
            SslConfig sslConfig = this.config.getSslConfig();
            this.channel = sslConfig.isSecure() ? new SecureSocketChannel(channel, sslConfig) : channel;
        }
    }

    private CharSequence readString() throws JournalNetworkException {
        this.charSequenceResponseConsumer.read(this.channel);
        return (CharSequence)this.charSequenceResponseConsumer.getValue();
    }

    private void resubscribe() {
        int n = this.subscriptions.size();
        for (int i = 0; i < n; ++i) {
            SubscriptionHolder h = this.subscriptions.get(i);
            this.subscribeOne(i, h, h.local.getName(), false);
        }
    }

    private void sendDisconnect() throws JournalNetworkException {
        this.commandProducer.write(this.channel, (byte)7);
    }

    private void sendProtocolVersion() throws JournalNetworkException {
        this.commandProducer.write(this.channel, (byte)8);
        this.intResponseProducer.write(this.channel, 2);
        this.checkAck();
    }

    private void sendReady() throws JournalNetworkException {
        this.commandProducer.write(this.channel, (byte)3);
        LOG.debug().$("Client ready: ").$(this.channel).$();
    }

    private void sendState() throws JournalNetworkException {
        int sz = this.writers.size();
        for (int i = 0; i < sz; ++i) {
            if (this.statusSentList.get(i) != 0) continue;
            this.commandProducer.write(this.channel, (byte)2);
            this.journalClientStateProducer.write(this.channel, new IndexedJournal(i, this.writers.getQuick(i)));
            this.checkAck();
            this.statusSentList.setQuick(i, 1);
        }
    }

    private void subscribe(JournalKey remote, JournalKey local, JournalListener journalListener, JournalWriter writer) {
        long cursor = this.subscriptionPubSequence.next();
        if (cursor < 0L) {
            throw new JournalRuntimeException("start client before subscribing", new Object[0]);
        }
        SubscriptionHolder h = this.subscriptionQueue.get(cursor);
        h.type = 0;
        h.remote = remote;
        h.local = local;
        h.listener = journalListener;
        h.writer = writer;
        this.subscriptionPubSequence.done(cursor);
    }

    private <T> void subscribe(Class<T> clazz, JournalListener journalListener) {
        this.subscribe(new JournalKey<T>(clazz), new JournalKey<T>(clazz), journalListener);
    }

    private <T> void subscribe(Class<T> clazz, String location, JournalListener journalListener) {
        this.subscribe(new JournalKey<T>(clazz, location), new JournalKey<T>(clazz, location), journalListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribeOne(int index, SubscriptionHolder holder, String name, boolean newSubscription) {
        if (newSubscription) {
            SubscriptionHolder sub = new SubscriptionHolder();
            sub.local = holder.local;
            sub.remote = holder.remote;
            sub.listener = holder.listener;
            sub.writer = holder.writer;
            this.subscriptions.add(sub);
        }
        JournalWriter writer = this.writers.getQuiet(index);
        try {
            JournalMetadata metadata;
            this.commandProducer.write(this.channel, (byte)1);
            this.setKeyRequestProducer.write(this.channel, new IndexedJournalKey(index, holder.remote));
            this.checkAck();
            File file = Files.makeTempFile();
            try {
                try (HugeBufferConsumer h = new HugeBufferConsumer(file);){
                    h.read(this.channel);
                    metadata = new JournalMetadata(h.getHb(), name);
                }
                catch (JournalException e) {
                    throw new JournalNetworkException(e);
                }
            }
            finally {
                Files.delete(file);
            }
            boolean validate = true;
            if (writer == null) {
                if (holder.writer == null) {
                    try {
                        writer = this.factory.writer(metadata);
                    }
                    catch (JournalException e) {
                        LOG.error().$("Failed to create writer: ").$(e).$();
                        this.unsubscribe(index, null, holder, 2);
                        return;
                    }
                    this.writersToClose.add(writer);
                    validate = false;
                } else {
                    writer = holder.writer;
                }
                writer.disableCommitOnClose();
                this.statusSentList.extendAndSet(index, 0);
                this.deltaConsumers.extendAndSet(index, new JournalDeltaConsumer(writer));
                this.writers.extendAndSet(index, writer);
                writer.setJournalListener(holder.listener);
            } else {
                this.statusSentList.setQuick(index, 0);
            }
            if (validate && !metadata.isCompatible(writer.getMetadata(), false)) {
                LOG.error().$("Journal ").$(holder.local.getName()).$(" is not compatible with ").$(holder.remote.getName()).$("(remote)").$();
                this.unsubscribe(index, writer, holder, 2);
                return;
            }
            this.commandProducer.write(this.channel, (byte)2);
            this.journalClientStateProducer.write(this.channel, new IndexedJournal(index, writer));
            this.checkAck();
            this.statusSentList.setQuick(index, 1);
            if (holder.listener != null) {
                holder.listener.onEvent(6);
            }
            LOG.info().$("Subscribed ").$(name).$(" to ").$(holder.remote.getName()).$("(remote)").$();
        }
        catch (JournalNetworkException e) {
            LOG.error().$("Failed to subscribe ").$(name).$(" to ").$(holder.remote.getName()).$("(remote)").$();
            this.unsubscribe(index, writer, holder, 5);
        }
    }

    private void unsubscribe(int index, JournalWriter writer, SubscriptionHolder holder, int reason) {
        JournalDeltaConsumer deltaConsumer = this.deltaConsumers.getQuiet(index);
        if (deltaConsumer != null) {
            deltaConsumer.free();
        }
        if (writer != null && this.writersToClose.remove(writer) > -1) {
            writer.close();
        }
        if (index < this.writers.size()) {
            this.writers.setQuick(index, null);
        }
        try {
            this.commandProducer.write(this.channel, (byte)16);
            this.setKeyRequestProducer.write(this.channel, new IndexedJournalKey(index, holder.remote));
            this.checkAck();
        }
        catch (JournalNetworkException e) {
            LOG.error().$("Failed to unsubscribe journal ").$(holder.remote.getName()).$(e).$();
            this.notifyCallback(257);
        }
        if (reason == 2) {
            this.subscribedJournals.remove(holder.local.getName());
            int n = this.subscriptions.size();
            for (int i = 0; i < n; ++i) {
                SubscriptionHolder h = this.subscriptions.getQuick(i);
                if (!h.local.getName().equals(holder.local.getName())) continue;
                this.subscriptions.remove(i);
                break;
            }
        }
        if (holder.listener != null) {
            holder.listener.onEvent(reason);
        }
    }

    static /* synthetic */ boolean access$1402(JournalClient x0, boolean x1) {
        x0.running = x1;
        return x0.running;
    }

    static /* synthetic */ void access$1500(JournalClient x0, int x1) {
        x0.notifyCallback(x1);
    }

    static /* synthetic */ ClientConfig access$1600(JournalClient x0) {
        return x0.config;
    }

    static /* synthetic */ void access$1700(JournalClient x0) {
        x0.closeChannel();
    }

    static /* synthetic */ void access$1800(JournalClient x0) throws JournalNetworkException {
        x0.openChannel();
    }

    static /* synthetic */ AtomicInteger access$1900() {
        return counter;
    }

    static /* synthetic */ void access$2000(JournalClient x0) throws JournalNetworkException {
        x0.sendProtocolVersion();
    }

    static /* synthetic */ void access$2100(JournalClient x0) throws JournalNetworkException, AuthenticationProviderException, UnauthorizedException, AuthenticationConfigException {
        x0.checkAuthAndSendCredential();
    }

    static /* synthetic */ void access$2200(JournalClient x0) {
        x0.resubscribe();
    }

    static /* synthetic */ void access$2300(JournalClient x0) throws JournalNetworkException {
        x0.sendReady();
    }

    static /* synthetic */ void access$2400(JournalClient x0) {
        x0.close0();
    }

    static /* synthetic */ ByteChannel access$2500(JournalClient x0) {
        return x0.channel;
    }

    static /* synthetic */ CommandConsumer access$2600(JournalClient x0) {
        return x0.commandConsumer;
    }

    static /* synthetic */ StatsCollectingReadableByteChannel access$2700(JournalClient x0) {
        return x0.statsChannel;
    }

    static /* synthetic */ IntResponseConsumer access$2800(JournalClient x0) {
        return x0.intResponseConsumer;
    }

    static /* synthetic */ ObjList access$2900(JournalClient x0) {
        return x0.deltaConsumers;
    }

    static /* synthetic */ IntList access$3000(JournalClient x0) {
        return x0.statusSentList;
    }

    static /* synthetic */ void access$3100(JournalClient x0) throws JournalNetworkException {
        x0.sendState();
    }

    static /* synthetic */ void access$3200(JournalClient x0) throws JournalNetworkException {
        x0.sendDisconnect();
    }

    static /* synthetic */ CountDownLatch access$3300(JournalClient x0) {
        return x0.haltLatch;
    }

    private final class Handler
    extends Thread {
        private Handler() {
        }

        public boolean isRunning() {
            long cursor = JournalClient.this.subscriptionSubSequence.next();
            if (cursor < 0L) {
                return true;
            }
            long available = JournalClient.this.subscriptionSubSequence.available();
            while (cursor < available) {
                SubscriptionHolder holder = (SubscriptionHolder)JournalClient.this.subscriptionQueue.get(cursor++);
                if (holder.type != 1) continue;
                return false;
            }
            return true;
        }

        public boolean processSubscriptionQueue() {
            long cursor = JournalClient.this.subscriptionSubSequence.next();
            if (cursor < 0L) {
                return true;
            }
            long available = JournalClient.this.subscriptionSubSequence.available();
            int i = JournalClient.this.writers.size();
            block5: while (cursor < available) {
                SubscriptionHolder holder = (SubscriptionHolder)JournalClient.this.subscriptionQueue.get(cursor++);
                switch (holder.type) {
                    case 0: {
                        String name = holder.local.getName();
                        if (JournalClient.this.subscribedJournals.add(name)) {
                            JournalClient.this.subscribeOne(i++, holder, name, true);
                            continue block5;
                        }
                        if (holder.listener != null) {
                            holder.listener.onEvent(1);
                        }
                        LOG.error().$("Already subscribed ").$(name).$();
                        continue block5;
                    }
                    case 2: {
                        continue block5;
                    }
                    case 1: {
                        return false;
                    }
                }
                LOG.error().$("Ignored unknown message: ").$(holder.type).$();
            }
            JournalClient.this.subscriptionSubSequence.done(available - 1L);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block31: {
                JournalClient.access$1402(JournalClient.this, true);
                JournalClient.access$1500(JournalClient.this, 2);
                event = 0;
                connected = false;
                block22: while (true) {
                    if (connected) ** GOTO lbl55
                    retryCount = JournalClient.access$1600(JournalClient.this).getReconnectPolicy().getRetryCount();
                    loginRetryCount = JournalClient.access$1600(JournalClient.this).getReconnectPolicy().getLoginRetryCount();
                    while (true) {
                        try {
                            while (true) {
                                JournalClient.access$1700(JournalClient.this);
                                try {
                                    JournalClient.access$1800(JournalClient.this);
                                    JournalClient.access$1900().incrementAndGet();
                                }
                                catch (JournalNetworkException e) {
                                    if (retryCount-- > 0) {
                                        continue;
                                    }
                                    ** GOTO lbl53
                                }
                                break;
                            }
                            JournalClient.access$2000(JournalClient.this);
                            JournalClient.access$2100(JournalClient.this);
                            JournalClient.access$2200(JournalClient.this);
                            JournalClient.access$2300(JournalClient.this);
                            connected = true;
                            JournalClient.access$1500(JournalClient.this, 32);
                            ** GOTO lbl49
                        }
                        catch (UnauthorizedException e) {
                            JournalClient.access$1500(JournalClient.this, 128);
                            --loginRetryCount;
                            ** GOTO lbl49
                        }
                        catch (AuthenticationConfigException | AuthenticationProviderException e) {
                            JournalClient.access$1700(JournalClient.this);
                            JournalClient.access$2400(JournalClient.this);
                            JournalClient.access$1500(JournalClient.this, 64);
                            JournalClient.access$1402(JournalClient.this, false);
                            JournalClient.access$1500(JournalClient.this, 256);
                            JournalClient.access$3300(JournalClient.this).countDown();
                            JournalClient.access$1300().info().$("Terminated").$();
                            return;
                        }
                        catch (JournalNetworkException e) {
                            try {
                                JournalClient.access$1300().info().$(e.getMessage()).$();
                                JournalClient.access$1700(JournalClient.this);
lbl49:
                                // 3 sources

                                if (!connected && retryCount-- > 0 && loginRetryCount > 0) {
                                    LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(JournalClient.access$1600(JournalClient.this).getReconnectPolicy().getSleepBetweenRetriesMillis()));
                                    JournalClient.access$1300().info().$("Retrying reconnect ... [").$(retryCount + 1).$(']').$();
                                    continue;
                                }
lbl53:
                                // 3 sources

                                if (!(connected || retryCount != 0 && loginRetryCount != 0)) {
                                    event = 1;
                                }
lbl55:
                                // 4 sources

                                try {
                                    if (connected && JournalClient.access$2500(JournalClient.this).isOpen() && this.isRunning()) {
                                        JournalClient.access$2600(JournalClient.this).read(JournalClient.access$2500(JournalClient.this));
                                        cmd = JournalClient.access$2600(JournalClient.this).getCommand();
                                        switch (cmd) {
                                            case 4: {
                                                JournalClient.access$2700(JournalClient.this).setDelegate(JournalClient.access$2500(JournalClient.this));
                                                index = JournalClient.access$2800(JournalClient.this).getValue(JournalClient.access$2700(JournalClient.this));
                                                ((JournalDeltaConsumer)JournalClient.access$2900(JournalClient.this).getQuick(index)).read(JournalClient.access$2700(JournalClient.this));
                                                JournalClient.access$3000(JournalClient.this).set(index, 0);
                                                JournalClient.access$2700(JournalClient.this).logStats();
                                                break;
                                            }
                                            case 5: {
                                                JournalClient.access$3100(JournalClient.this);
                                                JournalClient.access$2300(JournalClient.this);
                                                break;
                                            }
                                            case 6: {
                                                if (this.processSubscriptionQueue()) {
                                                    JournalClient.access$2300(JournalClient.this);
                                                    break;
                                                }
                                                event = 4;
                                                break;
                                            }
                                            case 12: {
                                                connected = false;
                                                break;
                                            }
                                            default: {
                                                JournalClient.access$1300().info().$("Unknown command: ").$(cmd).$();
                                                break;
                                            }
                                        }
                                        continue block22;
                                    }
                                    if (event != 0) continue block22;
                                    event = 4;
                                    continue block22;
                                }
                                catch (IncompatibleJournalException e) {
                                    JournalClient.access$1300().error().$(e.getMessage()).$();
                                    event = 16;
                                    continue block22;
                                }
                                catch (JournalNetworkException e) {
                                    JournalClient.access$1300().error().$("Network error. Server died?").$();
                                    JournalClient.access$1300().debug().$("Network error details: ").$(e).$();
                                    JournalClient.access$1500(JournalClient.this, 258);
                                    connected = false;
                                    continue block22;
                                }
                                catch (Throwable e) {
                                    JournalClient.access$1300().error().$("Unhandled exception in client").$(e).$();
                                    event = 8;
                                }
                                if (event == 0) continue block22;
                                if (JournalClient.access$2500(JournalClient.this) != null && JournalClient.access$2500(JournalClient.this).isOpen()) {
                                    JournalClient.access$3200(JournalClient.this);
                                }
                                JournalClient.access$1700(JournalClient.this);
                                JournalClient.access$2400(JournalClient.this);
                                JournalClient.access$1500(JournalClient.this, event);
                                break block31;
                            }
                            catch (Throwable e) {
                                JournalClient.access$1300().error().$("Fatal exception when closing client").$(e).$();
                                JournalClient.access$1700(JournalClient.this);
                                JournalClient.access$2400(JournalClient.this);
                                break block31;
                            }
                            catch (Throwable var6_15) {
                                throw var6_15;
                            }
                        }
                        break;
                    }
                    break;
                }
                finally {
                    JournalClient.access$1402(JournalClient.this, false);
                    JournalClient.access$1500(JournalClient.this, 256);
                    JournalClient.access$3300(JournalClient.this).countDown();
                    JournalClient.access$1300().info().$("Terminated").$();
                }
            }
        }
    }

    private static class SubscriptionHolder {
        private static final ObjectFactory<SubscriptionHolder> FACTORY = SubscriptionHolder::new;
        private int type = 0;
        private JournalKey remote;
        private JournalKey local;
        private JournalListener listener;
        private JournalWriter writer;

        private SubscriptionHolder() {
        }

        static /* synthetic */ ObjectFactory access$000() {
            return FACTORY;
        }
    }

    public static interface Callback {
        public void onEvent(int var1);
    }
}

