/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.net.SecureSocketChannel;
import com.questdb.net.ha.ClusterStatusListener;
import com.questdb.net.ha.JournalEventPublisher;
import com.questdb.net.ha.JournalServerAgent;
import com.questdb.net.ha.SocketChannelHolder;
import com.questdb.net.ha.auth.AuthorizationHandler;
import com.questdb.net.ha.bridge.JournalEventBridge;
import com.questdb.net.ha.config.ServerConfig;
import com.questdb.net.ha.config.ServerNode;
import com.questdb.net.ha.mcast.OnDemandAddressSender;
import com.questdb.net.ha.model.IndexedJournalKey;
import com.questdb.net.ha.protocol.CommandProducer;
import com.questdb.net.ha.protocol.commands.IntResponseConsumer;
import com.questdb.net.ha.protocol.commands.IntResponseProducer;
import com.questdb.std.NamedDaemonThreadFactory;
import com.questdb.std.ObjIntHashMap;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.store.JournalKey;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.ReaderFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.ByteChannel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class JournalServer {
    private static final Log LOG = LogFactory.getLog(JournalServer.class);
    private static final int ER_NEW_SERVER_JOINED = 1;
    private static final int ER_FORWARD_ELECTED_THEIRS = 2;
    private static final int ER_FORWARD_ELECTED_OURS = 3;
    private static final int ER_INSISTING = 4;
    private static final int ER_FORWARD_ELECTION_THEIRS = 5;
    private static final int ER_FORWARD_ELECTION_OURS = 6;
    private static final int ER_CHANGING_ELECTION_TO_OURS = 7;
    private static final int ER_ANNOUNCE_LEADER = 8;
    private final AtomicInteger writerIdGenerator = new AtomicInteger(0);
    private final ObjIntHashMap<JournalWriter> writers = new ObjIntHashMap();
    private final ReaderFactory factory;
    private final JournalEventBridge bridge;
    private final ServerConfig config;
    private final ThreadPoolExecutor service;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final List<SocketChannelHolder> channels = new CopyOnWriteArrayList<SocketChannelHolder>();
    private final OnDemandAddressSender addressSender;
    private final AuthorizationHandler authorizationHandler;
    private final int uid;
    private final IntResponseConsumer intResponseConsumer = new IntResponseConsumer();
    private final IntResponseProducer intResponseProducer = new IntResponseProducer();
    private ServerSocketChannel serverSocketChannel;
    private boolean leader = false;
    private boolean participant = false;
    private boolean passiveNotified = false;
    private boolean activeNotified = false;
    private ClusterStatusListener clusterStatusListener;

    public JournalServer(ReaderFactory factory) {
        this(new ServerConfig(), factory);
    }

    public JournalServer(ReaderFactory factory, AuthorizationHandler authorizationHandler) {
        this(new ServerConfig(), factory, authorizationHandler);
    }

    public JournalServer(ServerConfig config, ReaderFactory factory) {
        this(config, factory, null);
    }

    public JournalServer(ServerConfig config, ReaderFactory factory, AuthorizationHandler authorizationHandler) {
        this(config, factory, authorizationHandler, 0);
    }

    public JournalServer(ServerConfig config, ReaderFactory factory, AuthorizationHandler authorizationHandler, int instance) {
        this.config = config;
        this.factory = factory;
        this.service = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamedDaemonThreadFactory("questdb-server-" + instance + "-agent", true));
        this.bridge = new JournalEventBridge(config.getHeartbeatFrequency(), TimeUnit.MILLISECONDS);
        this.addressSender = config.isMultiCastEnabled() ? new OnDemandAddressSender(config, 230, 235, instance) : null;
        this.authorizationHandler = authorizationHandler;
        this.uid = instance;
    }

    public JournalEventBridge getBridge() {
        return this.bridge;
    }

    public int getConnectedClients() {
        return this.channels.size();
    }

    public ReaderFactory getFactory() {
        return this.factory;
    }

    public void halt(long timeout, TimeUnit unit) {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        LOG.info().$("Stopping agent services ").$(this.uid).$();
        this.service.shutdown();
        LOG.info().$("Stopping acceptor").$();
        try {
            this.serverSocketChannel.close();
        }
        catch (IOException e) {
            LOG.debug().$("Error closing socket").$(e).$();
        }
        if (timeout > 0L) {
            try {
                LOG.info().$("Waiting for ").$(this.service.getActiveCount()).$(" agent services to complete data exchange on ").$(this.uid).$();
                this.service.awaitTermination(timeout, unit);
            }
            catch (InterruptedException e) {
                LOG.debug().$("Interrupted wait").$(e).$();
            }
        }
        if (this.addressSender != null) {
            LOG.info().$("Stopping mcast sender on ").$(this.uid).$();
            this.addressSender.halt();
        }
        LOG.info().$("Closing channels on ").$(this.uid).$();
        this.closeChannels();
        try {
            if (timeout > 0L) {
                LOG.info().$("Waiting for ").$(this.service.getActiveCount()).$(" agent services to stop on ").$(this.uid).$();
                this.service.awaitTermination(timeout, unit);
            }
            LOG.info().$("Server ").$(this.uid).$(" is shutdown").$();
        }
        catch (InterruptedException e) {
            LOG.info().$("Server ").$(this.uid).$(" is shutdown, but some connections are still lingering.").$();
        }
    }

    public void halt() {
        this.halt(30L, TimeUnit.SECONDS);
    }

    public synchronized boolean isLeader() {
        return this.leader;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public synchronized void joinCluster(ClusterStatusListener clusterStatusListener) {
        if (this.isRunning()) {
            this.passiveNotified = false;
            this.clusterStatusListener = clusterStatusListener;
            this.fwdElectionMessage(1, this.uid, (byte)13, 0);
        }
    }

    public void publish(JournalWriter journal) {
        this.writers.put(journal, this.writerIdGenerator.getAndIncrement());
    }

    public void start() throws JournalNetworkException {
        for (ObjIntHashMap.Entry<JournalWriter> entry : this.writers) {
            JournalEventPublisher publisher = new JournalEventPublisher(entry.value, this.bridge);
            ((JournalWriter)entry.key).setJournalListener(publisher);
        }
        this.serverSocketChannel = this.config.openServerSocketChannel(this.uid);
        if (this.config.isMultiCastEnabled()) {
            this.addressSender.start();
        }
        this.running.set(true);
        this.service.execute(new Acceptor());
    }

    private void addChannel(SocketChannelHolder holder) {
        this.channels.add(holder);
    }

    private void closeChannel(SocketChannelHolder holder, boolean force) {
        if (holder != null) {
            try {
                if (holder.socketAddress != null) {
                    if (force) {
                        LOG.info().$("Server node ").$(this.uid).$(": Client forced out: ").$(holder.socketAddress.toString()).$();
                    } else {
                        LOG.info().$("Server node ").$(this.uid).$(": Client disconnected: ").$(holder.socketAddress.toString()).$();
                    }
                }
                holder.byteChannel.close();
            }
            catch (IOException e) {
                LOG.error().$("Server node ").$(this.uid).$(": Cannot close channel [").$(holder.byteChannel).$("]: ").$(e.getMessage()).$();
            }
        }
    }

    private void closeChannels() {
        for (SocketChannelHolder h : this.channels) {
            this.closeChannel(h, true);
        }
        this.channels.clear();
    }

    private synchronized void fwdElectionMessage(int reason, int uid, byte command, int count) {
        this.participant = true;
        this.service.submit(new ElectionForwarder(reason, uid, command, count));
    }

    IndexedJournalKey getWriterIndex0(JournalKey key) {
        for (ObjIntHashMap.Entry<JournalWriter> e : this.writers.immutableIterator()) {
            JournalKey jk = ((JournalWriter)e.key).getMetadata().getKey();
            if (!((JournalWriter)e.key).getName().equals(key.getName())) continue;
            return new IndexedJournalKey(e.value, new JournalKey(jk.getModelClass(), jk.getName(), jk.getPartitionBy(), jk.getRecordHint()));
        }
        return null;
    }

    synchronized void handleElectedMessage(ByteChannel channel) throws JournalNetworkException {
        int theirUuid = this.intResponseConsumer.getValue(channel);
        int hops = this.intResponseConsumer.getValue(channel);
        int ourUuid = this.uid;
        if (this.isRunning()) {
            if (theirUuid != ourUuid) {
                this.participant = false;
                if (hops < this.config.getNodeCount() + 2) {
                    if (this.leader && theirUuid > ourUuid) {
                        this.leader = false;
                    }
                    this.fwdElectionMessage(2, theirUuid, (byte)14, hops + 1);
                    if (!this.passiveNotified && this.clusterStatusListener != null) {
                        this.clusterStatusListener.goPassive(this.config.getNodeByUID(theirUuid));
                        this.passiveNotified = true;
                    }
                } else {
                    this.fwdElectionMessage(3, ourUuid, (byte)13, 0);
                }
            } else if (this.leader && !this.activeNotified && this.clusterStatusListener != null) {
                LOG.info().$(ourUuid).$(" is THE LEADER").$();
                this.clusterStatusListener.goActive();
                this.activeNotified = true;
            }
            this.intResponseProducer.write(channel, 252);
        } else {
            this.intResponseProducer.write(channel, 253);
        }
    }

    synchronized void handleElectionMessage(ByteChannel channel) throws JournalNetworkException {
        int theirUid = this.intResponseConsumer.getValue(channel);
        int hops = this.intResponseConsumer.getValue(channel);
        int ourUid = this.uid;
        if (this.isRunning()) {
            if (this.leader && theirUid != ourUid) {
                LOG.info().$(ourUid).$(" is insisting on leadership").$();
                this.fwdElectionMessage(4, ourUid, (byte)14, 0);
            } else if (theirUid > ourUid) {
                if (hops < this.config.getNodeCount() + 2) {
                    this.fwdElectionMessage(5, theirUid, (byte)13, hops + 1);
                } else {
                    this.fwdElectionMessage(6, ourUid, (byte)13, 0);
                }
            } else if (theirUid < ourUid && !this.participant) {
                this.fwdElectionMessage(7, ourUid, (byte)13, 0);
            } else if (!this.leader && theirUid == ourUid) {
                this.leader = true;
                this.participant = false;
                this.fwdElectionMessage(8, ourUid, (byte)14, 0);
            }
            this.intResponseProducer.write(channel, 252);
        } else {
            this.intResponseProducer.write(channel, 253);
        }
    }

    private SocketChannel openSocketChannel0(ServerNode node, long timeout) throws IOException {
        InetSocketAddress address = new InetSocketAddress(node.getHostname(), node.getPort());
        NetworkChannel channel = ((SocketChannel)((SocketChannel)SocketChannel.open().setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, Boolean.FALSE)).setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)32768)).setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)32768);
        ((AbstractSelectableChannel)((Object)channel)).configureBlocking(false);
        try {
            ((SocketChannel)channel).connect(address);
            long t = System.currentTimeMillis();
            while (!((SocketChannel)channel).finishConnect()) {
                LockSupport.parkNanos(500000L);
                if (System.currentTimeMillis() - t <= timeout) continue;
                throw new IOException("Connection timeout");
            }
            ((AbstractSelectableChannel)((Object)channel)).configureBlocking(true);
            LOG.info().$("Connected to ").$(node).$(" [").$(((SocketChannel)channel).getLocalAddress()).$(']').$();
            return channel;
        }
        catch (IOException e) {
            ((AbstractInterruptibleChannel)((Object)channel)).close();
            throw e;
        }
    }

    private void removeChannel(SocketChannelHolder holder) {
        if (this.channels.remove(holder)) {
            this.closeChannel(holder, false);
        }
    }

    static /* synthetic */ void access$1000(JournalServer x0, SocketChannelHolder x1) {
        x0.removeChannel(x1);
    }

    class Handler
    implements Runnable {
        private final JournalServerAgent agent;
        private final SocketChannelHolder holder;

        Handler(SocketChannelHolder holder) {
            this.holder = holder;
            this.agent = new JournalServerAgent(JournalServer.this, holder.socketAddress, JournalServer.this.authorizationHandler);
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class Acceptor
    implements Runnable {
        private Acceptor() {
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (JournalServer.this.running.get()) {
                        SocketChannel channel = JournalServer.this.serverSocketChannel.accept();
                        if (channel == null) continue;
                        SocketChannelHolder holder = new SocketChannelHolder(JournalServer.this.config.getSslConfig().isSecure() ? new SecureSocketChannel(channel, JournalServer.this.config.getSslConfig()) : channel, channel.getRemoteAddress());
                        JournalServer.this.addChannel(holder);
                        try {
                            JournalServer.this.service.submit(new Handler(holder));
                            LOG.info().$("Server node ").$(JournalServer.this.uid).$(": Connected ").$(holder.socketAddress).$();
                            continue block4;
                        }
                        catch (RejectedExecutionException e) {
                            LOG.info().$("Node ").$(JournalServer.this.uid).$(" ignoring connection from ").$(holder.socketAddress).$(". Server is shutting down.").$();
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    if (!JournalServer.this.running.get()) break;
                    LOG.error().$("Acceptor dying").$(e).$();
                    break;
                }
            }
            LOG.info().$("Acceptor shutdown on ").$(JournalServer.this.uid).$();
        }
    }

    private class ElectionForwarder
    implements Runnable {
        private final CommandProducer commandProducer = new CommandProducer();
        private final IntResponseProducer intResponseProducer = new IntResponseProducer();
        private final IntResponseConsumer intResponseConsumer = new IntResponseConsumer();
        private final byte command;
        private final int uid;
        private final int count;
        private final int electionReason;

        public ElectionForwarder(int electionReason, int uid, byte command, int count) {
            this.electionReason = electionReason;
            this.command = command;
            this.uid = uid;
            this.count = count;
        }

        @Override
        public void run() {
            int peer = JournalServer.this.config.getNodePosition(JournalServer.this.uid);
            while (true) {
                if (++peer == JournalServer.this.config.getNodeCount()) {
                    peer = 0;
                }
                ServerNode node = JournalServer.this.config.getNodeByPosition(peer);
                try {
                    SocketChannel channel = JournalServer.this.openSocketChannel0(node, 2000L);
                    Throwable throwable = null;
                    try {
                        this.commandProducer.write(channel, this.command);
                        this.intResponseProducer.write(channel, this.uid);
                        this.intResponseProducer.write(channel, this.count);
                        LOG.info().$(this.electionReason).$("> ").$(this.command).$(" [").$(this.uid).$("]{").$(this.count).$("} ").$(JournalServer.this.uid).$(" -> ").$(node.getId()).$();
                        if (this.intResponseConsumer.getValue(channel) == 252) break;
                        LOG.info().$("Node ").$(peer).$(" is shutting down").$();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (channel == null) continue;
                        if (throwable != null) {
                            try {
                                channel.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        channel.close();
                    }
                }
                catch (Exception e) {
                    LOG.info().$("Dead node ").$(peer).$(": ").$(e.getMessage()).$();
                }
            }
        }
    }
}

