/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.net.ha.JournalServer;
import com.questdb.net.ha.StatsCollectingWritableByteChannel;
import com.questdb.net.ha.auth.AuthorizationHandler;
import com.questdb.net.ha.bridge.JournalEventHandler;
import com.questdb.net.ha.bridge.JournalEventProcessor;
import com.questdb.net.ha.comsumer.JournalClientStateConsumer;
import com.questdb.net.ha.config.ServerConfig;
import com.questdb.net.ha.model.IndexedJournalKey;
import com.questdb.net.ha.model.JournalClientState;
import com.questdb.net.ha.producer.HugeBufferProducer;
import com.questdb.net.ha.producer.JournalDeltaProducer;
import com.questdb.net.ha.protocol.CommandConsumer;
import com.questdb.net.ha.protocol.CommandProducer;
import com.questdb.net.ha.protocol.commands.ByteArrayResponseConsumer;
import com.questdb.net.ha.protocol.commands.IntResponseConsumer;
import com.questdb.net.ha.protocol.commands.IntResponseProducer;
import com.questdb.net.ha.protocol.commands.SetKeyRequestConsumer;
import com.questdb.net.ha.protocol.commands.StringResponseProducer;
import com.questdb.std.IntIntHashMap;
import com.questdb.std.IntList;
import com.questdb.std.ObjList;
import com.questdb.std.ex.JournalDisconnectedChannelException;
import com.questdb.std.ex.JournalException;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.store.Journal;
import com.questdb.store.JournalKey;
import java.io.File;
import java.net.SocketAddress;
import java.nio.channels.ByteChannel;
import java.nio.channels.WritableByteChannel;

public class JournalServerAgent {
    private static final Log LOG = LogFactory.getLog(JournalServerAgent.class);
    private static final byte JOURNAL_INDEX_NOT_FOUND = -1;
    private final IntIntHashMap writerToReaderMap = new IntIntHashMap();
    private final IntList readerToWriterMap = new IntList();
    private final JournalServer server;
    private final CommandConsumer commandConsumer = new CommandConsumer();
    private final CommandProducer commandProducer = new CommandProducer();
    private final SetKeyRequestConsumer setKeyRequestConsumer = new SetKeyRequestConsumer();
    private final StringResponseProducer stringResponseProducer = new StringResponseProducer();
    private final JournalClientStateConsumer journalClientStateConsumer = new JournalClientStateConsumer();
    private final IntResponseProducer intResponseProducer = new IntResponseProducer();
    private final IntResponseConsumer intResponseConsumer = new IntResponseConsumer();
    private final ObjList<Journal> readers = new ObjList();
    private final ObjList<JournalDeltaProducer> producers = new ObjList();
    private final ObjList<JournalClientState> clientStates = new ObjList();
    private final StatsCollectingWritableByteChannel statsChannel;
    private final JournalEventProcessor eventProcessor;
    private final EventHandler handler = new EventHandler();
    private final AuthorizationHandler authorizationHandler;
    private final ByteArrayResponseConsumer byteArrayResponseConsumer = new ByteArrayResponseConsumer();
    private final SocketAddress socketAddress;
    private boolean authorized;

    public JournalServerAgent(JournalServer server, SocketAddress socketAddress, AuthorizationHandler authorizationHandler) {
        this.server = server;
        this.socketAddress = socketAddress;
        this.statsChannel = new StatsCollectingWritableByteChannel(socketAddress);
        this.eventProcessor = new JournalEventProcessor(server.getBridge());
        this.authorizationHandler = authorizationHandler;
        this.authorized = authorizationHandler == null;
        this.readerToWriterMap.zero(-1);
    }

    public void close() {
        int i;
        this.server.getBridge().removeAgentSequence(this.eventProcessor.getSequence());
        this.journalClientStateConsumer.free();
        this.commandConsumer.free();
        this.setKeyRequestConsumer.free();
        this.intResponseConsumer.free();
        this.byteArrayResponseConsumer.free();
        this.commandProducer.free();
        this.stringResponseProducer.free();
        this.intResponseProducer.free();
        int n = this.readers.size();
        for (i = 0; i < n; ++i) {
            Journal r = this.readers.getQuick(i);
            if (r == null) continue;
            r.close();
        }
        int k = this.producers.size();
        for (i = 0; i < k; ++i) {
            this.producers.getQuick(i).free();
        }
    }

    public void process(ByteChannel channel) throws JournalNetworkException {
        this.commandConsumer.read(channel);
        switch (this.commandConsumer.getCommand()) {
            case 1: {
                this.addClientKey(channel);
                break;
            }
            case 16: {
                this.removeClientKey(channel);
                break;
            }
            case 2: {
                this.checkAuthorized(channel);
                LOG.debug().$(this.socketAddress).$(" DeltaRequest command received").$();
                this.journalClientStateConsumer.read(channel);
                this.storeDeltaRequest(channel, (JournalClientState)this.journalClientStateConsumer.getValue());
                break;
            }
            case 3: {
                this.checkAuthorized(channel);
                this.statsChannel.setDelegate(channel);
                this.dispatch(this.statsChannel);
                this.statsChannel.logStats();
                break;
            }
            case 7: {
                throw new JournalDisconnectedChannelException();
            }
            case 8: {
                this.checkProtocolVersion(channel, this.intResponseConsumer.getValue(channel));
                break;
            }
            case 9: {
                if (this.authorized) {
                    this.ok(channel);
                    break;
                }
                this.stringResponseProducer.write(channel, "AUTH");
                break;
            }
            case 10: {
                this.byteArrayResponseConsumer.read(channel);
                this.authorize(channel, (byte[])this.byteArrayResponseConsumer.getValue());
                break;
            }
            case 13: {
                this.server.handleElectionMessage(channel);
                break;
            }
            case 14: {
                this.server.handleElectedMessage(channel);
                break;
            }
            default: {
                throw new JournalNetworkException("Corrupt channel");
            }
        }
    }

    private void addClientKey(ByteChannel channel) throws JournalNetworkException {
        this.setKeyRequestConsumer.read(channel);
        IndexedJournalKey indexedKey = (IndexedJournalKey)this.setKeyRequestConsumer.getValue();
        LOG.debug().$(this.socketAddress).$(" AddKey command received. Index: ").$(indexedKey.getIndex()).$();
        JournalKey readerKey = indexedKey.getKey();
        int index = indexedKey.getIndex();
        IndexedJournalKey augmentedReaderKey = this.server.getWriterIndex0(readerKey);
        if (augmentedReaderKey == null) {
            this.error(channel, "Requested key not exported: " + readerKey);
        } else {
            this.writerToReaderMap.put(augmentedReaderKey.getIndex(), index);
            this.readerToWriterMap.extendAndSet(index, augmentedReaderKey.getIndex());
            try {
                this.createReader(index, augmentedReaderKey.getKey());
                this.ok(channel);
                this.sendMetadata(channel, index);
            }
            catch (JournalException e) {
                this.error(channel, "Could not created reader for key: " + readerKey, e);
            }
        }
    }

    private void authorize(WritableByteChannel channel, byte[] value) throws JournalNetworkException {
        if (!this.authorized) {
            try {
                int k = this.readers.size();
                ObjList<JournalKey> keys = new ObjList<JournalKey>(k);
                for (int i = 0; i < k; ++i) {
                    keys.add(this.readers.getQuick(i).getMetadata().getKey());
                }
                this.authorized = this.authorizationHandler.isAuthorized(value, keys);
            }
            catch (Throwable e) {
                LOG.error().$(this.socketAddress).$(" Exception in authorization handler:").$(e).$();
                this.authorized = false;
            }
        }
        if (this.authorized) {
            this.ok(channel);
        } else {
            this.error(channel, "Unauthorized");
        }
    }

    private void checkAuthorized(WritableByteChannel channel) throws JournalNetworkException {
        if (!this.authorized) {
            this.error(channel, "NOT AUTHORIZED");
            throw new JournalDisconnectedChannelException();
        }
    }

    private void checkProtocolVersion(ByteChannel channel, int version) throws JournalNetworkException {
        if (version == 2) {
            this.ok(channel);
        } else {
            this.error(channel, "Unsupported protocol version. Client: " + version + ", Server: " + 2);
        }
    }

    private <T> void createReader(int index, JournalKey<T> key) throws JournalException {
        JournalDeltaProducer producer;
        Journal<T> journal = this.readers.getQuiet(index);
        if (journal == null) {
            journal = this.server.getFactory().reader(key);
            this.readers.extendAndSet(index, journal);
        }
        if ((producer = this.producers.getQuiet(index)) == null) {
            this.producers.extendAndSet(index, new JournalDeltaProducer(journal));
        }
    }

    private void dispatch(WritableByteChannel channel) throws JournalNetworkException {
        if (!this.processJournalEvents(channel, false)) {
            this.processJournalEvents(channel, true);
        }
    }

    private boolean dispatch0(WritableByteChannel channel, int journalIndex) {
        long time = System.currentTimeMillis();
        JournalClientState state = this.clientStates.get(journalIndex);
        if (state == null || state.isClientStateInvalid() || state.isWaitingOnEvents() && time - state.getClientStateSyncTime() <= ServerConfig.SYNC_TIMEOUT) {
            return false;
        }
        try {
            boolean dataSent = this.dispatchProducer(channel, state.getTxn(), state.getTxPin(), this.getProducer(journalIndex), journalIndex);
            if (dataSent) {
                state.invalidateClientState();
            } else {
                state.setClientStateSyncTime(time);
            }
            return dataSent;
        }
        catch (Exception e) {
            LOG.error().$(this.socketAddress).$(" Client appears to be refusing new data from server, corrupt client").$(e).$();
            return false;
        }
    }

    private boolean dispatchProducer(WritableByteChannel channel, long txn, long txPin, JournalDeltaProducer journalDeltaProducer, int index) throws JournalNetworkException, JournalException {
        journalDeltaProducer.configure(txn, txPin);
        if (journalDeltaProducer.hasContent()) {
            LOG.debug().$(this.socketAddress).$(" Sending data [").$(txn).$(',').$(txPin).$(']').$();
            this.commandProducer.write(channel, (byte)4);
            this.intResponseProducer.write(channel, index);
            journalDeltaProducer.write(channel);
            return true;
        }
        LOG.debug().$(this.socketAddress).$(" Nothing to send [").$(txn).$(',').$(txPin).$(']').$();
        return false;
    }

    private void error(WritableByteChannel channel, String message) throws JournalNetworkException {
        this.error(channel, message, null);
    }

    private void error(WritableByteChannel channel, String message, Exception e) throws JournalNetworkException {
        this.stringResponseProducer.write(channel, message);
        LOG.info().$(this.socketAddress).$(' ').$(message).$(e).$();
    }

    private JournalDeltaProducer getProducer(int index) {
        return this.producers.get(index);
    }

    private void ok(WritableByteChannel channel) throws JournalNetworkException {
        this.stringResponseProducer.write(channel, "OK");
    }

    private boolean processJournalEvents(WritableByteChannel channel, boolean blocking) throws JournalNetworkException {
        this.handler.setChannel(channel);
        boolean dataSent = false;
        if (this.eventProcessor.process(this.handler, blocking)) {
            dataSent = this.handler.isDataSent();
            int k = this.clientStates.size();
            for (int i = 0; i < k; ++i) {
                JournalClientState state = this.clientStates.getQuick(i);
                if (state == null) continue;
                if (state.isWaitingOnEvents()) {
                    dataSent = this.dispatch0(channel, i) || dataSent;
                }
                state.setWaitingOnEvents(true);
            }
            if (dataSent) {
                this.commandProducer.write(channel, (byte)5);
            } else if (blocking) {
                this.commandProducer.write(channel, (byte)6);
            }
        } else if (this.server.isRunning()) {
            this.commandProducer.write(channel, (byte)6);
        } else {
            this.commandProducer.write(channel, (byte)12);
        }
        return dataSent;
    }

    private void removeClientKey(ByteChannel channel) throws JournalNetworkException {
        this.setKeyRequestConsumer.read(channel);
        IndexedJournalKey indexedKey = (IndexedJournalKey)this.setKeyRequestConsumer.getValue();
        LOG.debug().$(this.socketAddress).$(" RemoveKey command received. Index: ").$(indexedKey.getIndex()).$();
        JournalKey readerKey = indexedKey.getKey();
        int index = indexedKey.getIndex();
        IndexedJournalKey augmentedReaderKey = this.server.getWriterIndex0(readerKey);
        if (augmentedReaderKey == null) {
            this.error(channel, "Requested key not exported: " + readerKey);
        } else {
            this.writerToReaderMap.put(augmentedReaderKey.getIndex(), -1);
            this.readerToWriterMap.extendAndSet(index, -1);
            this.removeReader(index);
            this.clientStates.setQuick(index, null);
            this.ok(channel);
        }
    }

    private void removeReader(int index) {
        JournalDeltaProducer producer;
        Journal journal = this.readers.getQuiet(index);
        if (journal != null) {
            journal.close();
            if (index < this.readers.size()) {
                this.readers.setQuick(index, null);
            }
        }
        if ((producer = this.producers.getQuiet(index)) != null) {
            producer.free();
            if (index < this.producers.size()) {
                this.producers.setQuick(index, null);
            }
        }
    }

    private void sendMetadata(WritableByteChannel channel, int index) throws JournalException, JournalNetworkException {
        try (HugeBufferProducer h = new HugeBufferProducer(new File(this.readers.get(index).getLocation(), "_meta2"));){
            h.write(channel);
        }
    }

    private void storeDeltaRequest(WritableByteChannel channel, JournalClientState request) throws JournalNetworkException {
        int index = request.getJournalIndex();
        if (this.readerToWriterMap.getQuiet(index) == -1) {
            this.error(channel, "Journal index does not match key request");
        } else {
            JournalClientState r = this.clientStates.getQuiet(index);
            if (r == null) {
                r = new JournalClientState();
                this.clientStates.extendAndSet(index, r);
            }
            request.deepCopy(r);
            r.invalidateClientState();
            r.setClientStateSyncTime(0L);
            r.setWaitingOnEvents(true);
            this.ok(channel);
        }
    }

    private class EventHandler
    implements JournalEventHandler {
        private WritableByteChannel channel;
        private boolean dataSent = false;

        private EventHandler() {
        }

        @Override
        public void handle(int index) {
            int journalIndex = JournalServerAgent.this.writerToReaderMap.get(index);
            if (journalIndex != -1) {
                assert (journalIndex < JournalServerAgent.this.clientStates.size());
                JournalClientState status = (JournalClientState)JournalServerAgent.this.clientStates.getQuick(journalIndex);
                if (status != null && status.isWaitingOnEvents()) {
                    status.setWaitingOnEvents(false);
                    this.dataSent = JournalServerAgent.this.dispatch0(this.channel, journalIndex) || this.dataSent;
                }
            }
        }

        public boolean isDataSent() {
            return this.dataSent;
        }

        public void setChannel(WritableByteChannel channel) {
            this.channel = channel;
            this.dataSent = false;
        }
    }
}

