/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.bridge;

import com.questdb.mp.Barrier;
import com.questdb.mp.FanOut;
import com.questdb.mp.MPSequence;
import com.questdb.mp.RingQueue;
import com.questdb.mp.SCSequence;
import com.questdb.mp.Sequence;
import com.questdb.mp.TimeoutBlockingWaitStrategy;
import com.questdb.net.ha.bridge.JournalEvent;
import java.util.concurrent.TimeUnit;

public class JournalEventBridge {
    private static final int BUFFER_SIZE = 1024;
    private final RingQueue<JournalEvent> queue = new RingQueue<JournalEvent>(JournalEvent.EVENT_FACTORY, 1024);
    private final Sequence publisher = new MPSequence(1024);
    private final FanOut fanOut = new FanOut(new Barrier[0]);
    private final long time;
    private final TimeUnit unit;

    public JournalEventBridge(long time, TimeUnit unit) {
        this.publisher.then(this.fanOut).then(this.publisher);
        this.time = time;
        this.unit = unit;
    }

    public Sequence createAgentSequence() {
        return this.fanOut.addAndGet(new SCSequence(this.publisher.current(), new TimeoutBlockingWaitStrategy(this.time, this.unit)));
    }

    public RingQueue<JournalEvent> getQueue() {
        return this.queue;
    }

    public void publish(int journalIndex, long timestamp) {
        long cursor = this.publisher.nextBully();
        JournalEvent event = this.queue.get(cursor);
        event.setIndex(journalIndex);
        event.setTimestamp(timestamp);
        this.publisher.done(cursor);
    }

    public void removeAgentSequence(Sequence sequence) {
        this.fanOut.remove(sequence);
    }
}

