/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.bridge;

import com.questdb.ex.TimeoutException;
import com.questdb.mp.RingQueue;
import com.questdb.mp.Sequence;
import com.questdb.net.ha.bridge.JournalEvent;
import com.questdb.net.ha.bridge.JournalEventBridge;
import com.questdb.net.ha.bridge.JournalEventHandler;

public class JournalEventProcessor {
    private final RingQueue<JournalEvent> queue;
    private final Sequence sequence;

    public JournalEventProcessor(JournalEventBridge bridge) {
        this.queue = bridge.getQueue();
        this.sequence = bridge.createAgentSequence();
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public boolean process(JournalEventHandler handler, boolean blocking) {
        try {
            long cursor;
            long l = cursor = blocking ? this.sequence.waitForNext() : this.sequence.next();
            if (cursor >= 0L) {
                int index = this.queue.get(cursor).getIndex();
                this.sequence.done(cursor);
                handler.handle(index);
            }
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }
}

