/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.comsumer;

import com.questdb.net.ha.AbstractChannelConsumer;
import com.questdb.std.ByteBuffers;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.store.AbstractColumn;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;

public class FixedColumnDeltaConsumer
extends AbstractChannelConsumer {
    private final ByteBuffer header = ByteBuffer.allocateDirect(8).order(ByteOrder.LITTLE_ENDIAN);
    private final long headerAddress = ByteBuffers.getAddress(this.header);
    private final AbstractColumn column;
    private long targetOffset = -1L;

    public FixedColumnDeltaConsumer(AbstractColumn column) {
        this.column = column;
    }

    @Override
    public void free() {
        ByteBuffers.release(this.header);
    }

    @Override
    protected void commit() {
        this.column.preCommit(this.targetOffset);
    }

    @Override
    protected void doRead(ReadableByteChannel channel) throws JournalNetworkException {
        int sz;
        long offset;
        this.header.position(0);
        ByteBuffers.copy(channel, this.header);
        this.targetOffset = offset + (long)Unsafe.getUnsafe().getInt(this.headerAddress);
        for (offset = this.column.getOffset(); offset < this.targetOffset && (sz = ByteBuffers.copy(channel, this.column.getBuffer(offset), this.targetOffset - offset)) != 0; offset += (long)sz) {
        }
    }
}

