/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.comsumer;

import com.questdb.net.ha.ChannelConsumer;
import com.questdb.std.ByteBuffers;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalException;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.store.UnstructuredFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;

public class HugeBufferConsumer
implements ChannelConsumer,
Closeable {
    private final ByteBuffer header = ByteBuffer.allocateDirect(8).order(ByteOrder.LITTLE_ENDIAN);
    private final long headerAddress = ByteBuffers.getAddress(this.header);
    private final UnstructuredFile hb;

    public HugeBufferConsumer(File file) throws JournalException {
        this.hb = new UnstructuredFile(file, 16, 2);
    }

    @Override
    public void close() {
        this.free();
    }

    @Override
    public void free() {
        this.hb.close();
    }

    @Override
    public void read(ReadableByteChannel channel) throws JournalNetworkException {
        try {
            this.header.position(0);
            channel.read(this.header);
            long target = Unsafe.getUnsafe().getLong(this.headerAddress);
            for (long pos = 0L; pos < target; pos += (long)ByteBuffers.copy(channel, this.hb.getBuffer(pos), target - pos)) {
            }
        }
        catch (IOException e) {
            throw new JournalNetworkException(e);
        }
    }

    public UnstructuredFile getHb() {
        return this.hb;
    }
}

