/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.comsumer;

import com.questdb.ex.IncompatibleJournalException;
import com.questdb.net.ha.AbstractChannelConsumer;
import com.questdb.net.ha.comsumer.JournalServerStateConsumer;
import com.questdb.net.ha.comsumer.JournalSymbolTableConsumer;
import com.questdb.net.ha.comsumer.PartitionDeltaConsumer;
import com.questdb.net.ha.model.JournalServerState;
import com.questdb.std.ObjList;
import com.questdb.std.ex.JournalException;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.std.time.Interval;
import com.questdb.store.JournalWriter;
import com.questdb.store.TempPartition;
import java.nio.channels.ReadableByteChannel;

public class JournalDeltaConsumer
extends AbstractChannelConsumer {
    private final JournalWriter journal;
    private final JournalServerStateConsumer journalServerStateConsumer = new JournalServerStateConsumer();
    private final JournalSymbolTableConsumer journalSymbolTableConsumer;
    private final ObjList<PartitionDeltaConsumer> partitionDeltaConsumers = new ObjList();
    private JournalServerState state;
    private PartitionDeltaConsumer lagPartitionDeltaConsumer;

    public JournalDeltaConsumer(JournalWriter journal) {
        this.journal = journal;
        this.journalSymbolTableConsumer = new JournalSymbolTableConsumer(journal);
    }

    @Override
    public void free() {
        this.journalServerStateConsumer.free();
        this.journalSymbolTableConsumer.free();
        int k = this.partitionDeltaConsumers.size();
        for (int i = 0; i < k; ++i) {
            PartitionDeltaConsumer dc = this.partitionDeltaConsumers.getQuick(i);
            if (dc == null) continue;
            dc.free();
        }
        if (this.lagPartitionDeltaConsumer != null) {
            this.lagPartitionDeltaConsumer.free();
        }
    }

    @Override
    protected void commit() throws JournalNetworkException {
        try {
            this.journal.commit(false, this.state.getTxn(), this.state.getTxPin());
        }
        catch (JournalException e) {
            throw new JournalNetworkException(e);
        }
    }

    @Override
    protected void doRead(ReadableByteChannel channel) throws JournalNetworkException {
        try {
            this.reset();
            this.journalServerStateConsumer.read(channel);
            this.state = (JournalServerState)this.journalServerStateConsumer.getValue();
            if (this.state.getTxn() == -1L) {
                this.journal.notifyListener(3);
                throw new IncompatibleJournalException("Server refused txn for %s", this.journal.getLocation());
            }
            if (this.state.getTxn() < this.journal.getTxn()) {
                this.journal.rollback(this.state.getTxn(), this.state.getTxPin());
                return;
            }
            this.journal.beginTx();
            this.createPartitions(this.state);
            if (this.state.isSymbolTables()) {
                this.journalSymbolTableConsumer.read(channel);
            }
            int k = this.state.getNonLagPartitionCount();
            for (int i = 0; i < k; ++i) {
                JournalServerState.PartitionMetadata meta = this.state.getMeta(i);
                if (meta.getEmpty() != 0) continue;
                PartitionDeltaConsumer partitionDeltaConsumer = this.getPartitionDeltaConsumer(meta.getPartitionIndex());
                partitionDeltaConsumer.read(channel);
            }
            if (this.state.getLagPartitionName() == null && this.journal.hasIrregularPartition()) {
                this.journal.removeIrregularPartition();
            } else if (this.state.getLagPartitionName() != null) {
                if (this.lagPartitionDeltaConsumer == null || !this.journal.hasIrregularPartition() || !this.state.getLagPartitionName().equals(this.journal.getIrregularPartition().getName())) {
                    TempPartition temp = this.journal.createTempPartition(this.state.getLagPartitionName());
                    this.lagPartitionDeltaConsumer = new PartitionDeltaConsumer(temp.open());
                    this.journal.setIrregularPartition(temp);
                }
                this.lagPartitionDeltaConsumer.read(channel);
            }
        }
        catch (JournalException e) {
            throw new JournalNetworkException(e);
        }
    }

    private void createPartitions(JournalServerState metadata) throws JournalException {
        int pc = this.journal.nonLagPartitionCount() - 1;
        int k = metadata.getNonLagPartitionCount();
        for (int i = 0; i < k; ++i) {
            JournalServerState.PartitionMetadata partitionMetadata = metadata.getMeta(i);
            if (partitionMetadata.getPartitionIndex() <= pc) continue;
            Interval interval = new Interval(partitionMetadata.getIntervalEnd(), partitionMetadata.getIntervalStart());
            this.journal.createPartition(interval, partitionMetadata.getPartitionIndex());
        }
    }

    private PartitionDeltaConsumer getPartitionDeltaConsumer(int partitionIndex) throws JournalException {
        PartitionDeltaConsumer consumer = this.partitionDeltaConsumers.getQuiet(partitionIndex);
        if (consumer == null) {
            consumer = new PartitionDeltaConsumer(this.journal.getPartition(partitionIndex, true));
            this.partitionDeltaConsumers.extendAndSet(partitionIndex, consumer);
        }
        return consumer;
    }

    private void reset() throws JournalException {
        int k = this.partitionDeltaConsumers.size();
        for (int i = 0; i < k; ++i) {
            PartitionDeltaConsumer c = this.partitionDeltaConsumers.getAndSetQuick(i, null);
            if (c != null) {
                c.free();
            }
            this.journal.getPartition(i, false).close();
        }
    }
}

