/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.comsumer;

import com.questdb.net.ha.AbstractMutableObjectConsumer;
import com.questdb.net.ha.model.JournalServerState;
import java.nio.ByteBuffer;

public class JournalServerStateConsumer
extends AbstractMutableObjectConsumer<JournalServerState> {
    private char[] lagPartitionNameChars;

    @Override
    protected JournalServerState newInstance() {
        return new JournalServerState();
    }

    @Override
    protected void read(ByteBuffer buffer, JournalServerState obj) {
        obj.reset();
        obj.setTxn(buffer.getLong());
        obj.setTxPin(buffer.getLong());
        obj.setSymbolTables(buffer.get() == 1);
        int partitionCount = buffer.getInt();
        obj.setNonLagPartitionCount(partitionCount);
        for (int i = 0; i < partitionCount; ++i) {
            obj.addPartitionMetadata(buffer.getInt(), buffer.getLong(), buffer.getLong(), buffer.get());
        }
        int len = buffer.getChar();
        if (len > 0) {
            if (this.lagPartitionNameChars == null || this.lagPartitionNameChars.length < len) {
                this.lagPartitionNameChars = new char[len];
            }
            for (int i = 0; i < len; ++i) {
                this.lagPartitionNameChars[i] = buffer.getChar();
            }
            obj.setLagPartitionName(new String(this.lagPartitionNameChars, 0, len));
        } else {
            obj.setLagPartitionName(null);
        }
        obj.setLagPartitionMetadata(buffer.getInt(), buffer.getLong(), buffer.getLong(), buffer.get());
    }
}

