/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.comsumer;

import com.questdb.net.ha.AbstractChannelConsumer;
import com.questdb.net.ha.comsumer.VariableColumnDeltaConsumer;
import com.questdb.std.ByteBuffers;
import com.questdb.std.IntList;
import com.questdb.std.ObjList;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.store.Journal;
import com.questdb.store.MMappedSymbolTable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;

public class JournalSymbolTableConsumer
extends AbstractChannelConsumer {
    private final ByteBuffer buffer;
    private final long address;
    private final ObjList<VariableColumnDeltaConsumer> symbolTableConsumers;
    private final ObjList<MMappedSymbolTable> symbolTables;
    private final IntList symbolTableSizes;
    private final int tabCount;

    public JournalSymbolTableConsumer(Journal journal) {
        this.tabCount = journal.getSymbolTableCount();
        this.buffer = ByteBuffer.allocateDirect(this.tabCount).order(ByteOrder.LITTLE_ENDIAN);
        this.address = ByteBuffers.getAddress(this.buffer);
        this.symbolTableConsumers = new ObjList(this.tabCount);
        this.symbolTables = new ObjList(this.tabCount);
        this.symbolTableSizes = new IntList(this.tabCount);
        while (this.symbolTableSizes.size() < this.tabCount) {
            this.symbolTableSizes.add(-1);
        }
        for (int i = 0; i < this.tabCount; ++i) {
            MMappedSymbolTable tab = journal.getSymbolTable(i);
            this.symbolTableConsumers.extendAndSet(i, new VariableColumnDeltaConsumer(tab.getDataColumn()));
            this.symbolTables.extendAndSet(i, tab);
            this.symbolTableSizes.setQuick(i, tab.size());
        }
    }

    @Override
    public void free() {
        ByteBuffers.release(this.buffer);
        for (int i = 0; i < this.tabCount; ++i) {
            this.symbolTableConsumers.getQuick(i).free();
        }
    }

    @Override
    protected void commit() {
        int sz = this.symbolTables.size();
        for (int i = 0; i < sz; ++i) {
            MMappedSymbolTable tab = this.symbolTables.getQuick(i);
            int oldSize = this.symbolTableSizes.getQuick(i);
            tab.getDataColumn().commit();
            tab.alignSize();
            tab.updateIndex(oldSize, tab.size());
            tab.commit();
        }
    }

    @Override
    protected void doRead(ReadableByteChannel channel) throws JournalNetworkException {
        this.buffer.position(0);
        ByteBuffers.copy(channel, this.buffer);
        for (int i = 0; i < this.tabCount; ++i) {
            this.symbolTableSizes.setQuick(i, this.symbolTables.getQuick(i).size());
            if (Unsafe.getUnsafe().getByte(this.address + (long)i) == 0) continue;
            this.symbolTableConsumers.getQuick(i).read(channel);
        }
    }
}

