/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.comsumer;

import com.questdb.net.ha.ChannelConsumer;
import com.questdb.net.ha.comsumer.ChannelConsumerGroup;
import com.questdb.net.ha.comsumer.FixedColumnDeltaConsumer;
import com.questdb.net.ha.comsumer.VariableColumnDeltaConsumer;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.store.AbstractColumn;
import com.questdb.store.Partition;
import com.questdb.store.VariableColumn;

public class PartitionDeltaConsumer
extends ChannelConsumerGroup {
    private final Partition partition;
    private long oldSize;

    public PartitionDeltaConsumer(Partition partition) {
        super(PartitionDeltaConsumer.getColumnConsumers(partition));
        this.partition = partition;
        this.oldSize = partition.size();
    }

    private static ChannelConsumer[] getColumnConsumers(Partition partition) {
        ChannelConsumer[] consumers = new ChannelConsumer[partition.getJournal().getMetadata().getColumnCount()];
        for (int i = 0; i < consumers.length; ++i) {
            AbstractColumn column = partition.getAbstractColumn(i);
            consumers[i] = column instanceof VariableColumn ? new VariableColumnDeltaConsumer((VariableColumn)column) : new FixedColumnDeltaConsumer(column);
        }
        return consumers;
    }

    @Override
    protected void commit() throws JournalNetworkException {
        super.commit();
        this.partition.commitColumns();
        this.partition.applyTx(-1L, null);
        long size = this.partition.size();
        this.partition.updateIndexes(this.oldSize, size);
        this.oldSize = size;
    }
}

