/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.config;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.net.ha.config.ClientReconnectPolicy;
import com.questdb.net.ha.config.DatagramChannelWrapper;
import com.questdb.net.ha.config.NetworkConfig;
import com.questdb.net.ha.config.ServerNode;
import com.questdb.net.ha.mcast.OnDemandAddressPoller;
import com.questdb.std.ex.JournalNetworkException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public class ClientConfig
extends NetworkConfig {
    private static final Log LOG = LogFactory.getLog(ClientConfig.class);
    private final ClientReconnectPolicy reconnectPolicy = new ClientReconnectPolicy();
    private int soSndBuf = 8192;
    private boolean keepAlive = true;
    private boolean tcpNoDelay = true;
    private int linger = 0;
    private long connectionTimeout = 500L;

    public ClientConfig() {
        this(null);
    }

    public ClientConfig(String hosts) {
        this.getSslConfig().setClient(true);
        if (hosts != null && hosts.length() > 0) {
            this.parseNodes(hosts);
        }
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public ClientReconnectPolicy getReconnectPolicy() {
        return this.reconnectPolicy;
    }

    public DatagramChannelWrapper openDatagramChannel() throws JournalNetworkException {
        return this.openDatagramChannel(this.getMultiCastInterface());
    }

    public SocketChannel openSocketChannel() throws JournalNetworkException {
        if (this.getNodeCount() == 0) {
            if (this.isMultiCastEnabled()) {
                this.addNode(this.pollServerAddress());
            } else {
                throw new JournalNetworkException("No server nodes");
            }
        }
        List<ServerNode> nodes = this.getServerNodes();
        int k = nodes.size();
        for (int i = 0; i < k; ++i) {
            ServerNode node = nodes.get(i);
            try {
                return this.openSocketChannel0(node);
            }
            catch (IOException | UnresolvedAddressException e) {
                LOG.info().$("Node ").$(node).$(" is unavailable [").$(e.getMessage()).$(']').$();
                continue;
            }
        }
        throw new JournalNetworkException("Could not connect to any node");
    }

    public SocketChannel openSocketChannel(ServerNode node) throws JournalNetworkException {
        try {
            return this.openSocketChannel0(node);
        }
        catch (IOException | UnresolvedAddressException e) {
            throw new JournalNetworkException(e);
        }
    }

    private boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    private int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    private NetworkInterface getMultiCastInterface() throws JournalNetworkException {
        try {
            if (this.getIfName() == null) {
                return this.findExternalNic();
            }
            return NetworkInterface.getByName(this.getIfName());
        }
        catch (IOException e) {
            throw new JournalNetworkException(e);
        }
    }

    private int getSoSndBuf() {
        return this.soSndBuf;
    }

    public void setSoSndBuf(int soSndBuf) {
        this.soSndBuf = soSndBuf;
    }

    private boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    private SocketChannel openSocketChannel0(ServerNode node) throws IOException {
        InetSocketAddress address = new InetSocketAddress(node.getHostname(), node.getPort());
        NetworkChannel channel = ((SocketChannel)((SocketChannel)((SocketChannel)((SocketChannel)SocketChannel.open().setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)this.isTcpNoDelay())).setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)this.getKeepAlive())).setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.getSoSndBuf())).setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.getSoRcvBuf())).setOption((SocketOption)StandardSocketOptions.SO_LINGER, (Object)this.getLinger());
        ((AbstractSelectableChannel)((Object)channel)).configureBlocking(false);
        try {
            ((SocketChannel)channel).connect(address);
            long t = System.currentTimeMillis();
            while (!((SocketChannel)channel).finishConnect()) {
                LockSupport.parkNanos(500000L);
                if (System.currentTimeMillis() - t <= this.connectionTimeout) continue;
                throw new IOException("Connection timeout");
            }
            ((AbstractSelectableChannel)((Object)channel)).configureBlocking(true);
            LOG.info().$("Connected to ").$(node).$(" [").$(((SocketChannel)channel).getLocalAddress()).$(']').$();
            return channel;
        }
        catch (IOException e) {
            ((AbstractInterruptibleChannel)((Object)channel)).close();
            throw e;
        }
    }

    private ServerNode pollServerAddress() throws JournalNetworkException {
        return (ServerNode)new OnDemandAddressPoller(this, 235, 230).poll(3, 500L, TimeUnit.MILLISECONDS);
    }
}

