/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.config;

import com.questdb.net.SslConfig;
import com.questdb.net.ha.config.DatagramChannelWrapper;
import com.questdb.net.ha.config.ServerNode;
import com.questdb.std.IntIntHashMap;
import com.questdb.std.ex.JournalNetworkException;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class NetworkConfig {
    public static final int DEFAULT_DATA_PORT = 7075;
    private static final String DEFAULT_MULTICAST_ADDRESS_IPV4 = "230.100.12.4";
    private static final String DEFAULT_MULTICAST_ADDRESS_IPV6_1 = "FF02:231::4500";
    private static final int DEFAULT_MULTICAST_PORT = 4446;
    private static final int DEFAULT_SO_RCVBUF = 0x100000;
    private final List<ServerNode> serverNodes = new ArrayList<ServerNode>();
    private final IntIntHashMap nodeLookup = new IntIntHashMap();
    private final SslConfig sslConfig = new SslConfig();
    private InetAddress multiCastAddress;
    private int multiCastPort = 4446;
    private int soRcvBuf = 0x100000;
    private boolean enableMultiCast = true;
    private String ifName = null;
    private NetworkInterface defaultInterface = null;

    public void addNode(ServerNode node) {
        this.serverNodes.add(node);
        this.nodeLookup.put(node.getId(), this.serverNodes.size() - 1);
    }

    public void clearNodes() {
        this.serverNodes.clear();
        this.nodeLookup.clear();
    }

    public ServerNode getNodeByPosition(int pos) {
        return this.serverNodes.get(pos);
    }

    public ServerNode getNodeByUID(int uid) {
        int pos = this.getNodePosition(uid);
        if (pos == -1) {
            return null;
        }
        return this.serverNodes.get(pos);
    }

    public int getNodeCount() {
        return this.serverNodes.size();
    }

    public int getNodePosition(int uid) {
        return this.nodeLookup.get(uid);
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public boolean isMultiCastEnabled() {
        return this.enableMultiCast;
    }

    public void setEnableMultiCast(boolean enableMultiCast) {
        this.enableMultiCast = enableMultiCast;
    }

    private static boolean isInet6(InetAddress address) {
        return address instanceof Inet6Address;
    }

    NetworkInterface findExternalNic() throws JournalNetworkException {
        if (this.defaultInterface != null) {
            return this.defaultInterface;
        }
        try {
            Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
            int index = Integer.MAX_VALUE;
            while (ifs.hasMoreElements()) {
                NetworkInterface q = ifs.nextElement();
                if (q.isLoopback() || !q.isUp() || q.getIndex() >= index) continue;
                this.defaultInterface = q;
                index = q.getIndex();
            }
            if (this.defaultInterface == null) {
                throw new JournalNetworkException("Could not find multicast-capable network interfaces");
            }
            return this.defaultInterface;
        }
        catch (SocketException e) {
            throw new JournalNetworkException(e);
        }
    }

    private InetAddress getDefaultMultiCastAddress(NetworkInterface ifn) throws JournalNetworkException {
        try {
            if (!ifn.supportsMulticast()) {
                throw new JournalNetworkException("Multicast is not supported on " + ifn.getName());
            }
            if (ifn.getInterfaceAddresses().isEmpty()) {
                throw new JournalNetworkException("No IP addresses assigned to " + ifn.getName());
            }
            if (NetworkConfig.isInet6(ifn.getInterfaceAddresses().get(0).getAddress())) {
                return InetAddress.getByName(DEFAULT_MULTICAST_ADDRESS_IPV6_1);
            }
            return InetAddress.getByName(DEFAULT_MULTICAST_ADDRESS_IPV4);
        }
        catch (Exception e) {
            throw new JournalNetworkException(e);
        }
    }

    String getIfName() {
        return this.ifName;
    }

    public void setIfName(String ifName) {
        this.ifName = ifName;
    }

    private InetAddress getMultiCastAddress() {
        return this.multiCastAddress;
    }

    public void setMultiCastAddress(InetAddress multiCastAddress) {
        this.multiCastAddress = multiCastAddress;
    }

    private int getMultiCastPort() {
        return this.multiCastPort;
    }

    public void setMultiCastPort(int multiCastPort) {
        this.multiCastPort = multiCastPort;
    }

    List<ServerNode> getServerNodes() {
        return this.serverNodes;
    }

    int getSoRcvBuf() {
        return this.soRcvBuf;
    }

    public void setSoRcvBuf(int soRcvBuf) {
        this.soRcvBuf = soRcvBuf;
    }

    DatagramChannelWrapper openDatagramChannel(NetworkInterface ifn) throws JournalNetworkException {
        InetAddress address = this.getMultiCastAddress();
        if (address == null) {
            address = this.getDefaultMultiCastAddress(ifn);
        }
        StandardProtocolFamily family = NetworkConfig.isInet6(address) ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
        try {
            DatagramChannel dc = ((DatagramChannel)((DatagramChannel)DatagramChannel.open(family).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, Boolean.TRUE)).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, ifn)).bind(new InetSocketAddress(this.getMultiCastPort()));
            dc.join(address, ifn);
            return new DatagramChannelWrapper(dc, new InetSocketAddress(address, this.getMultiCastPort()));
        }
        catch (IOException e) {
            throw new JournalNetworkException(e);
        }
    }

    void parseNodes(String nodes) {
        this.clearNodes();
        String[] parts = nodes.split(",");
        for (int i = 0; i < parts.length; ++i) {
            this.addNode(new ServerNode(i, parts[i]));
        }
    }
}

