/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.config;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.net.ha.config.DatagramChannelWrapper;
import com.questdb.net.ha.config.NetworkConfig;
import com.questdb.net.ha.config.ServerNode;
import com.questdb.std.ex.JournalNetworkException;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ServerConfig
extends NetworkConfig {
    public static final long SYNC_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
    private static final long DEFAULT_HEARTBEAT_FREQUENCY = TimeUnit.SECONDS.toMillis(5L);
    private static final Log LOG = LogFactory.getLog(ServerConfig.class);
    private long heartbeatFrequency = DEFAULT_HEARTBEAT_FREQUENCY;

    public long getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    public void setHeartbeatFrequency(long heartbeatFrequency) {
        this.heartbeatFrequency = heartbeatFrequency;
    }

    public NetworkInterface getMultiCastInterface(int instance) throws JournalNetworkException {
        NetworkInterface ifn = this.getMultiCastInterface0(instance);
        try {
            if (ifn.isUp()) {
                return ifn;
            }
        }
        catch (SocketException e) {
            throw new JournalNetworkException(e);
        }
        throw new JournalNetworkException("Network interface " + ifn.getName() + " is down");
    }

    public InetSocketAddress getSocketAddress(int instance) throws JournalNetworkException {
        ServerNode node = this.getNodeByUID(instance);
        try {
            if (node == null && this.getIfName() == null) {
                NetworkInterface ifn = NetworkInterface.getByInetAddress(InetAddress.getByName(InetAddress.getLocalHost().getHostName()));
                return ifn == null || this.hasIPv4Address(ifn) ? new InetSocketAddress("0.0.0.0", 7075) : new InetSocketAddress(InetAddress.getByName("0:0:0:0:0:0:0:0"), 7075);
            }
            if (node != null) {
                return new InetSocketAddress(node.getHostname(), node.getPort());
            }
            List<InterfaceAddress> addresses = NetworkInterface.getByName(this.getIfName()).getInterfaceAddresses();
            int sz = addresses.size();
            for (int i = 0; i < sz; ++i) {
                InetAddress addr = addresses.get(i).getAddress();
                if (!(addr instanceof Inet4Address) && !(addr instanceof Inet6Address)) continue;
                return new InetSocketAddress(addr, 7075);
            }
        }
        catch (IOException e) {
            throw new JournalNetworkException(e);
        }
        throw new JournalNetworkException("There are no usable IP addresses on " + this.getIfName());
    }

    public DatagramChannelWrapper openDatagramChannel(int instance) throws JournalNetworkException {
        return this.openDatagramChannel(this.getMultiCastInterface(instance));
    }

    public ServerSocketChannel openServerSocketChannel(int instance) throws JournalNetworkException {
        InetSocketAddress address = null;
        try {
            address = this.getSocketAddress(instance);
            NetworkChannel channel = ServerSocketChannel.open().bind(address).setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.getSoRcvBuf());
            LOG.info().$("Server is now listening on ").$(address).$();
            return channel;
        }
        catch (IOException e) {
            throw new JournalNetworkException("Cannot open server socket [" + address + ']', e);
        }
    }

    private NetworkInterface getMultiCastInterface0(int instance) throws JournalNetworkException {
        ServerNode node = this.getNodeByUID(instance);
        try {
            if (node == null && this.getIfName() == null) {
                return this.findExternalNic();
            }
            if (node != null && this.getIfName() == null) {
                InetAddress address = InetAddress.getByName(node.getHostname());
                if (!address.isAnyLocalAddress()) {
                    return NetworkInterface.getByInetAddress(address);
                }
                return this.findExternalNic();
            }
            return NetworkInterface.getByName(this.getIfName());
        }
        catch (IOException e) {
            throw new JournalNetworkException(e);
        }
    }

    private boolean hasIPv4Address(NetworkInterface ifn) {
        List<InterfaceAddress> addresses = ifn.getInterfaceAddresses();
        int sz = addresses.size();
        for (int i = 0; i < sz; ++i) {
            if (!(addresses.get(i).getAddress() instanceof Inet4Address)) continue;
            return true;
        }
        return false;
    }
}

