/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.config;

import com.questdb.common.JournalRuntimeException;
import com.questdb.common.NumericException;
import com.questdb.std.Numbers;
import org.jetbrains.annotations.NotNull;

public class ServerNode {
    private final int id;
    private final String address;
    private final String hostname;
    private final int port;

    public ServerNode(int id, @NotNull String address) {
        this.id = id;
        this.address = address;
        try {
            int ob = address.indexOf(91);
            if (ob > -1) {
                int cb = address.indexOf(93);
                this.hostname = address.substring(ob + 1, cb);
                this.port = address.length() > cb + 1 ? Numbers.parseInt(address.subSequence(cb + 2, address.length())) : 7075;
            } else {
                String[] parts = address.split(":");
                switch (parts.length) {
                    case 1: {
                        this.hostname = address;
                        this.port = 7075;
                        break;
                    }
                    case 2: {
                        this.hostname = parts[0];
                        this.port = Numbers.parseInt(parts[1]);
                        break;
                    }
                    default: {
                        throw NumericException.INSTANCE;
                    }
                }
            }
        }
        catch (NumericException e) {
            throw new JournalRuntimeException("Unknown host name format: " + address, new Object[0]);
        }
    }

    public ServerNode(int id, String hostname, int port) {
        this.id = id;
        this.hostname = hostname;
        this.port = port;
        this.address = hostname + ':' + port;
    }

    public String getAddress() {
        return this.address;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getId() {
        return this.id;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return "ServerNode{id=" + this.id + ", address='" + this.address + '\'' + '}';
    }
}

