/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.krb;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class ActiveDirectoryConnection
implements Closeable {
    private static final Log LOG = LogFactory.getLog(ActiveDirectoryConnection.class);
    private static final String JAAS_CONF = "/jaas.conf";
    private static final byte[] BYTES = new byte[0];
    private final Oid krb5MechOid;
    private final LoginContext loginContext;
    private final Subject subject;
    private final ServiceTicketEncoder encoder = new ServiceTicketEncoder();
    private final ServiceTicketDecoder decoder = new ServiceTicketDecoder();

    public ActiveDirectoryConnection(String krb5Conf, String principal, String keytab) throws IOException {
        URL cfg = this.getClass().getResource(JAAS_CONF);
        if (cfg == null) {
            throw new IOException("Not found: /jaas.conf");
        }
        System.setProperty("java.security.auth.login.config", cfg.toString());
        System.setProperty("java.security.krb5.conf", krb5Conf);
        System.setProperty("questkrb.principal", principal);
        System.setProperty("questkrb.keytab", keytab);
        System.setProperty("sun.security.krb5.debug", LOG.isDebugEnabled() ? "true" : "false");
        try {
            this.loginContext = new LoginContext("Krb5KeyTabLoginContext");
            this.loginContext.login();
            this.subject = this.loginContext.getSubject();
        }
        catch (LoginException e) {
            throw new IOException("ActiveDirectory login failed. ", e);
        }
        try {
            this.krb5MechOid = new Oid("1.2.840.113554.1.2.2");
        }
        catch (GSSException e) {
            throw new IOException("Cannot create Kerberos Oid.", e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.loginContext.logout();
        }
        catch (LoginException e) {
            throw new IOException(e);
        }
    }

    public String decodeServiceToken(String serviceName, byte[] serviceToken) throws IOException {
        try {
            return Subject.doAs(this.subject, this.decoder.$(serviceName, serviceToken));
        }
        catch (PrivilegedActionException e) {
            throw new IOException(e);
        }
    }

    public byte[] encodeServiceToken(String serviceName) throws IOException {
        try {
            return Subject.doAs(this.subject, this.encoder.$(serviceName));
        }
        catch (PrivilegedActionException e) {
            throw new IOException(e);
        }
    }

    private class ServiceTicketDecoder
    implements PrivilegedExceptionAction<String> {
        private String serviceName;
        private byte[] serviceTicket;

        private ServiceTicketDecoder() {
        }

        public ServiceTicketDecoder $(String serviceName, byte[] serviceTicket) {
            this.serviceName = serviceName;
            this.serviceTicket = serviceTicket;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String run() throws Exception {
            GSSManager gssManager = GSSManager.getInstance();
            GSSName spn = gssManager.createName(this.serviceName, null);
            GSSCredential credential = gssManager.createCredential(null, Integer.MAX_VALUE, ActiveDirectoryConnection.this.krb5MechOid, 2);
            GSSContext context = gssManager.createContext(spn, ActiveDirectoryConnection.this.krb5MechOid, credential, 0);
            try {
                context.acceptSecContext(this.serviceTicket, 0, this.serviceTicket.length);
                String string = context.getSrcName().toString();
                return string;
            }
            finally {
                context.dispose();
            }
        }
    }

    private class ServiceTicketEncoder
    implements PrivilegedExceptionAction<byte[]> {
        private String serviceName;

        private ServiceTicketEncoder() {
        }

        public ServiceTicketEncoder $(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] run() throws Exception {
            GSSManager gssManager = GSSManager.getInstance();
            GSSName spn = gssManager.createName(this.serviceName, null);
            GSSCredential credential = gssManager.createCredential(null, Integer.MAX_VALUE, ActiveDirectoryConnection.this.krb5MechOid, 1);
            GSSContext context = gssManager.createContext(spn, ActiveDirectoryConnection.this.krb5MechOid, credential, 0);
            try {
                byte[] byArray = context.initSecContext(BYTES, 0, 0);
                return byArray;
            }
            finally {
                context.dispose();
            }
        }
    }
}

