/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.krb;

import com.questdb.net.ha.auth.AuthorizationHandler;
import com.questdb.net.ha.krb.ActiveDirectoryConnection;
import com.questdb.net.ha.krb.KrbAuthorizer;
import com.questdb.std.ObjList;
import com.questdb.store.JournalKey;

public class KrbAuthenticator
implements AuthorizationHandler {
    private final String krb5Conf;
    private final String principal;
    private final String keyTab;
    private final String serviceName;
    private final KrbAuthorizer authorizer;

    public KrbAuthenticator(String krb5Conf, String principal, String keyTab, String serviceName, KrbAuthorizer authorizer) {
        this.krb5Conf = krb5Conf;
        this.principal = principal;
        this.keyTab = keyTab;
        this.serviceName = serviceName;
        this.authorizer = authorizer;
    }

    @Override
    public boolean isAuthorized(byte[] token, ObjList<JournalKey> requestedKeys) throws Exception {
        try (ActiveDirectoryConnection connection = new ActiveDirectoryConnection(this.krb5Conf, this.principal, this.keyTab);){
            String principal = connection.decodeServiceToken(this.serviceName, token);
            boolean bl = this.authorizer != null ? this.authorizer.isAuthorized(principal, requestedKeys) : principal != null;
            return bl;
        }
    }
}

