/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.krb;

import com.questdb.net.ha.auth.CredentialProvider;
import com.questdb.net.ha.krb.ActiveDirectoryConnection;

public class KrbCredentialProvider
implements CredentialProvider {
    private final String krb5Conf;
    private final String principal;
    private final String keyTab;
    private final String serviceName;

    public KrbCredentialProvider(String krb5Conf, String principal, String keyTab, String serviceName) {
        this.krb5Conf = krb5Conf;
        this.principal = principal;
        this.keyTab = keyTab;
        this.serviceName = serviceName;
    }

    @Override
    public byte[] createToken() throws Exception {
        try (ActiveDirectoryConnection connection = new ActiveDirectoryConnection(this.krb5Conf, this.principal, this.keyTab);){
            byte[] byArray = connection.encodeServiceToken(this.serviceName);
            return byArray;
        }
    }
}

