/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.mcast;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.net.ha.config.ClientConfig;
import com.questdb.net.ha.config.DatagramChannelWrapper;
import com.questdb.std.ByteBuffers;
import com.questdb.std.ex.JournalNetworkException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;
import java.util.concurrent.TimeUnit;

public abstract class AbstractOnDemandPoller<T> {
    private static final Log LOG = LogFactory.getLog(AbstractOnDemandPoller.class);
    private final ClientConfig networkConfig;
    private final int inMessageCode;
    private final int outMessageCode;

    AbstractOnDemandPoller(ClientConfig networkConfig, int inMessageCode, int outMessageCode) {
        this.networkConfig = networkConfig;
        this.inMessageCode = inMessageCode;
        this.outMessageCode = outMessageCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public T poll(int retryCount, long timeout, TimeUnit timeUnit) throws JournalNetworkException {
        try {
            Throwable throwable = null;
            try (DatagramChannelWrapper dcw = this.networkConfig.openDatagramChannel();){
                T t;
                DatagramChannel dc = dcw.getChannel();
                LOG.info().$("Polling on").$(dcw.getGroup()).$(" [").$(dc.getOption(StandardSocketOptions.IP_MULTICAST_IF).getName()).$(']').$();
                Selector selector = Selector.open();
                dc.configureBlocking(false);
                dc.register(selector, 1);
                ByteBuffer buf = ByteBuffer.allocateDirect(4096);
                try {
                    int count;
                    InetSocketAddress sa = null;
                    for (count = retryCount; count > 0 && (sa = this.poll0(dc, dcw.getGroup(), selector, buf, timeUnit.toMillis(timeout))) == null; --count) {
                        buf.clear();
                    }
                    if (count == 0) {
                        throw new JournalNetworkException("Cannot find QuestDB servers on network");
                    }
                    t = this.transform(buf, sa);
                }
                catch (Throwable throwable2) {
                    try {
                        ByteBuffers.release(buf);
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                ByteBuffers.release(buf);
                return t;
            }
        }
        catch (IOException e) {
            throw new JournalNetworkException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private InetSocketAddress poll0(DatagramChannel dc, SocketAddress group, Selector selector, ByteBuffer buf, long timeoutMillis) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 2[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract T transform(ByteBuffer var1, InetSocketAddress var2);
}

