/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.mcast;

import com.questdb.common.JournalRuntimeException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.net.ha.config.DatagramChannelWrapper;
import com.questdb.net.ha.config.ServerConfig;
import com.questdb.std.ByteBuffers;
import com.questdb.std.ex.JournalNetworkException;
import java.net.SocketAddress;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;

public abstract class AbstractOnDemandSender {
    private static final Log LOG = LogFactory.getLog(AbstractOnDemandSender.class);
    final int instance;
    private final ServerConfig serverConfig;
    private final int inMessageCode;
    private final int outMessageCode;
    private final String threadName;
    private Selector selector;
    private volatile boolean running = false;
    private volatile boolean selecting = false;
    private CountDownLatch latch;

    AbstractOnDemandSender(ServerConfig serverConfig, int inMessageCode, int outMessageCode, int instance) {
        this.serverConfig = serverConfig;
        this.inMessageCode = inMessageCode;
        this.outMessageCode = outMessageCode;
        this.threadName = "questdb-mcast-sender-" + instance;
        this.instance = instance;
    }

    public void halt() {
        if (this.running) {
            while (!this.selecting) {
                Thread.yield();
            }
            this.selector.wakeup();
            this.running = false;
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new JournalRuntimeException(e);
            }
        }
    }

    public void start() {
        if (!this.running) {
            this.running = true;
            this.latch = new CountDownLatch(1);
            Thread thread = new Thread(this::start0);
            thread.setName(this.threadName);
            thread.start();
        }
    }

    protected abstract void prepareBuffer(ByteBuffer var1) throws JournalNetworkException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start0() {
        try (DatagramChannelWrapper dcw = this.serverConfig.openDatagramChannel(this.instance);){
            DatagramChannel dc = dcw.getChannel();
            LOG.info().$("Sending to ").$(dcw.getGroup()).$(" on [").$(dc.getOption(StandardSocketOptions.IP_MULTICAST_IF).getName()).$(']').$();
            this.selector = Selector.open();
            this.selecting = true;
            dc.configureBlocking(false);
            dc.register(this.selector, 1);
            ByteBuffer buf = ByteBuffer.allocateDirect(4096);
            try {
                while (this.running) {
                    int updated = this.selector.select();
                    if (!this.running) {
                        break;
                    }
                    if (updated <= 0) continue;
                    Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        SelectionKey sk = iter.next();
                        iter.remove();
                        DatagramChannel ch = (DatagramChannel)sk.channel();
                        buf.clear();
                        SocketAddress sa = ch.receive(buf);
                        if (sa == null) continue;
                        buf.flip();
                        if (buf.remaining() < 4 || this.inMessageCode != buf.getInt(0)) continue;
                        LOG.debug().$("Sending server information [").$(this.inMessageCode).$("] to [").$(sa).$(']').$();
                        buf.clear();
                        buf.putInt(this.outMessageCode);
                        this.prepareBuffer(buf);
                        dc.send(buf, dcw.getGroup());
                    }
                }
            }
            finally {
                ByteBuffers.release(buf);
            }
        }
        catch (Throwable e) {
            LOG.error().$("Multicast sender crashed").$(e).$();
        }
        finally {
            this.latch.countDown();
        }
    }
}

