/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.mcast;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.net.ha.config.ClientConfig;
import com.questdb.net.ha.config.ServerNode;
import com.questdb.net.ha.mcast.AbstractOnDemandPoller;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public class OnDemandAddressPoller
extends AbstractOnDemandPoller<ServerNode> {
    private static final Log LOG = LogFactory.getLog(OnDemandAddressPoller.class);

    public OnDemandAddressPoller(ClientConfig clientConfig, int inMessageCode, int outMessageCode) {
        super(clientConfig, inMessageCode, outMessageCode);
    }

    @Override
    protected ServerNode transform(ByteBuffer buf, InetSocketAddress sa) {
        char[] chars = new char[buf.getChar()];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = buf.getChar();
        }
        buf.get();
        int port = buf.getInt();
        String addr = new String(chars);
        try {
            if (InetAddress.getByName(addr).isAnyLocalAddress() && sa != null) {
                return new ServerNode(0, sa.getAddress().getHostAddress(), port);
            }
        }
        catch (UnknownHostException e) {
            LOG.error().$("Got bad address [").$(addr).$("] from: ").$(sa).$();
        }
        return new ServerNode(0, addr, port);
    }
}

