/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.model;

import com.questdb.std.ObjList;

public class JournalServerState {
    private final ObjList<PartitionMetadata> partitionMetadata = new ObjList();
    private final PartitionMetadata lagPartitionMetadata = new PartitionMetadata();
    private boolean symbolTables = false;
    private int nonLagPartitionCount = 0;
    private int addIndex = 0;
    private String lagPartitionName;
    private boolean detachLag = false;
    private long txn;
    private long txPin;

    public void addPartitionMetadata(int partitionIndex, long intervalStart, long intervalEnd, byte empty) {
        PartitionMetadata partitionMetadata = this.getMeta(this.addIndex++);
        partitionMetadata.partitionIndex = partitionIndex;
        partitionMetadata.intervalStart = intervalStart;
        partitionMetadata.intervalEnd = intervalEnd;
        partitionMetadata.empty = empty;
    }

    public PartitionMetadata getLagPartitionMetadata() {
        return this.lagPartitionMetadata;
    }

    public String getLagPartitionName() {
        return this.lagPartitionName;
    }

    public void setLagPartitionName(String lagPartitionName) {
        this.lagPartitionName = lagPartitionName;
    }

    public PartitionMetadata getMeta(int index) {
        if (index >= this.nonLagPartitionCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        PartitionMetadata result = this.partitionMetadata.getQuiet(index);
        if (result == null) {
            result = new PartitionMetadata();
            this.partitionMetadata.extendAndSet(index, result);
        }
        return result;
    }

    public int getNonLagPartitionCount() {
        return this.nonLagPartitionCount;
    }

    public void setNonLagPartitionCount(int nonLagPartitionCount) {
        this.nonLagPartitionCount = nonLagPartitionCount;
    }

    public long getTxPin() {
        return this.txPin;
    }

    public void setTxPin(long txPin) {
        this.txPin = txPin;
    }

    public long getTxn() {
        return this.txn;
    }

    public void setTxn(long txn) {
        this.txn = txn;
    }

    public boolean isSymbolTables() {
        return this.symbolTables;
    }

    public void setSymbolTables(boolean symbolTables) {
        this.symbolTables = symbolTables;
    }

    public boolean notEmpty() {
        return this.nonLagPartitionCount != 0 || this.symbolTables || this.lagPartitionName != null || this.detachLag || this.txn == -1L;
    }

    public void reset() {
        this.nonLagPartitionCount = 0;
        this.addIndex = 0;
        this.symbolTables = false;
        this.lagPartitionMetadata.partitionIndex = -1;
        this.lagPartitionMetadata.intervalStart = 0L;
        this.lagPartitionMetadata.intervalEnd = 0L;
        this.detachLag = false;
        this.txn = 0L;
        this.txPin = 0L;
        this.lagPartitionName = null;
    }

    public void setDetachLag(boolean detachLag) {
        this.detachLag = detachLag;
    }

    public void setLagPartitionMetadata(int partitionIndex, long intervalStart, long intervalEnd, byte empty) {
        this.lagPartitionMetadata.partitionIndex = partitionIndex;
        this.lagPartitionMetadata.intervalStart = intervalStart;
        this.lagPartitionMetadata.intervalEnd = intervalEnd;
        this.lagPartitionMetadata.empty = empty;
    }

    public static final class PartitionMetadata {
        private int partitionIndex;
        private long intervalStart;
        private long intervalEnd;
        private byte empty = 0;

        public byte getEmpty() {
            return this.empty;
        }

        public long getIntervalEnd() {
            return this.intervalEnd;
        }

        public long getIntervalStart() {
            return this.intervalStart;
        }

        public int getPartitionIndex() {
            return this.partitionIndex;
        }
    }
}

