/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.producer;

import com.questdb.net.ha.ChannelProducer;
import com.questdb.std.ObjList;
import com.questdb.std.ex.JournalNetworkException;
import java.nio.channels.WritableByteChannel;

public class ChannelProducerGroup<T extends ChannelProducer>
implements ChannelProducer {
    private final ObjList<T> producers = new ObjList();
    private boolean hasContent = false;

    @Override
    public void free() {
        int sz = this.producers.size();
        for (int i = 0; i < sz; ++i) {
            ((ChannelProducer)this.producers.getQuick(i)).free();
        }
    }

    @Override
    public boolean hasContent() {
        return this.hasContent;
    }

    @Override
    public void write(WritableByteChannel channel) throws JournalNetworkException {
        if (this.hasContent) {
            int sz = this.producers.size();
            for (int i = 0; i < sz; ++i) {
                ((ChannelProducer)this.producers.getQuick(i)).write(channel);
            }
            this.hasContent = false;
        }
    }

    public String toString() {
        return "ChannelProducerGroup{size=" + this.producers.size() + '}';
    }

    void addProducer(T producer) {
        this.producers.add(producer);
    }

    void computeHasContent() {
        int sz = this.producers.size();
        for (int i = 0; i < sz && !(this.hasContent = ((ChannelProducer)this.producers.getQuick(i)).hasContent()); ++i) {
        }
    }

    ObjList<T> getProducers() {
        return this.producers;
    }
}

