/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.producer;

import com.questdb.net.ha.producer.ColumnDeltaProducer;
import com.questdb.std.ByteBuffers;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.store.AbstractColumn;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class FixedColumnDeltaProducer
implements ColumnDeltaProducer {
    private static final int REPLICATION_FRAGMENT_HEADER_SIZE = 8;
    private final ByteBuffer header = ByteBuffer.allocateDirect(8).order(ByteOrder.LITTLE_ENDIAN);
    private final AbstractColumn column;
    private long offset;
    private long targetOffset;
    private long nextOffset;
    private boolean hasContent = false;

    public FixedColumnDeltaProducer(AbstractColumn column) {
        this.column = column;
    }

    @Override
    public void configure(long localRowID, long limit) {
        long sz = this.column.size() - 1L;
        this.offset = localRowID > sz ? this.column.getOffset() : this.column.getOffset(localRowID);
        this.targetOffset = limit > sz ? this.column.getOffset() : this.column.getOffset(limit);
        this.header.rewind();
        this.header.putLong(this.targetOffset - this.offset);
        this.header.flip();
        this.nextOffset = this.offset;
        this.hasContent = this.targetOffset - this.offset > 0L;
    }

    @Override
    public void free() {
        ByteBuffers.release(this.header);
    }

    @Override
    public boolean hasContent() {
        return this.hasContent;
    }

    @Override
    public void write(WritableByteChannel channel) throws JournalNetworkException {
        if (this.hasContent()) {
            ByteBuffers.copy(this.header, channel);
            while (this.offset < this.targetOffset) {
                this.offset += (long)ByteBuffers.copy(this.column.getBuffer(this.offset), channel, this.targetOffset - this.offset);
            }
            this.hasContent = false;
        }
    }

    public String toString() {
        return "ColumnDelta{offset=" + this.offset + ", targetOffset=" + this.targetOffset + ", nextOffset=" + this.nextOffset + ", column=" + this.column + '}';
    }
}

