/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.producer;

import com.questdb.net.ha.ChannelProducer;
import com.questdb.std.ByteBuffers;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalException;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.store.UnstructuredFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class HugeBufferProducer
implements ChannelProducer,
Closeable {
    private final ByteBuffer header = ByteBuffer.allocateDirect(8);
    private final long headerAddress = ByteBuffers.getAddress(this.header);
    private final UnstructuredFile hb;

    public HugeBufferProducer(File file) throws JournalException {
        this.hb = new UnstructuredFile(file, 16, 0);
    }

    @Override
    public void close() {
        this.free();
    }

    @Override
    public void free() {
        ByteBuffers.release(this.header);
        this.hb.close();
    }

    @Override
    public boolean hasContent() {
        return true;
    }

    @Override
    public void write(WritableByteChannel channel) throws JournalNetworkException {
        long target = this.hb.getAppendOffset();
        Unsafe.getUnsafe().putLong(this.headerAddress, target);
        this.header.position(0);
        try {
            channel.write(this.header);
            for (long pos = 0L; pos < target; pos += (long)ByteBuffers.copy(this.hb.getBuffer(pos), channel, target - pos)) {
            }
        }
        catch (IOException e) {
            throw new JournalNetworkException(e);
        }
    }
}

