/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.producer;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.net.ha.ChannelProducer;
import com.questdb.net.ha.model.JournalServerState;
import com.questdb.net.ha.producer.JournalServerStateProducer;
import com.questdb.net.ha.producer.JournalSymbolTableProducer;
import com.questdb.net.ha.producer.PartitionDeltaProducer;
import com.questdb.std.ObjList;
import com.questdb.std.Rows;
import com.questdb.std.ex.JournalException;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.store.Journal;
import com.questdb.store.Partition;
import com.questdb.store.Tx;
import java.nio.channels.WritableByteChannel;

public class JournalDeltaProducer
implements ChannelProducer {
    private static final Log LOG = LogFactory.getLog(JournalDeltaProducer.class);
    private final Journal journal;
    private final JournalServerState journalServerState = new JournalServerState();
    private final JournalServerStateProducer journalServerStateProducer = new JournalServerStateProducer();
    private final ObjList<PartitionDeltaProducer> partitionDeltaProducers = new ObjList();
    private final ObjList<PartitionDeltaProducer> partitionDeltaProducerCache = new ObjList();
    private final JournalSymbolTableProducer journalSymbolTableProducer;
    private PartitionDeltaProducer lagPartitionDeltaProducer;

    public JournalDeltaProducer(Journal journal) {
        this.journal = journal;
        this.journalSymbolTableProducer = new JournalSymbolTableProducer(journal);
    }

    public void configure(long txn, long txPin) throws JournalException {
        this.journalServerState.reset();
        this.journal.refresh();
        long thisTxn = this.journal.getTxn();
        long thisTxnPin = this.journal.getTxPin();
        if (thisTxn < txn) {
            LOG.info().$("Cannot sync ").$(this.journal.getName()).$(". Client TXN is ahead of ours").$(" {txn:").$(txn).$(",pin:").$(txPin).$('}').$();
            this.journalServerState.setTxn(-1L);
        } else if (thisTxn == txn) {
            if (thisTxnPin != txPin) {
                LOG.info().$("Cannot sync ").$(this.journal.getName()).$(". Client TXN PIN is incorrect").$(" {txn:").$(txn).$(",pin:").$(txPin).$('}').$();
                this.journalServerState.setTxn(-1L);
            }
        } else if (thisTxn > txn) {
            Tx tx = this.journal.find(txn, txPin);
            if (tx == null) {
                LOG.info().$("Cannot sync ").$(this.journal.getName()).$(". Unknown TXN").$(" {txn:").$(txn).$(",pin:").$(txPin).$('}').$();
                this.journalServerState.setTxn(-1L);
            } else {
                this.journalServerState.setTxn(thisTxn);
                this.journalServerState.setTxPin(thisTxnPin);
                this.configure0(tx);
            }
        }
    }

    @Override
    public void free() {
        this.journalServerStateProducer.free();
        this.journalSymbolTableProducer.free();
        if (this.lagPartitionDeltaProducer != null) {
            this.lagPartitionDeltaProducer.free();
        }
        int sz = this.partitionDeltaProducerCache.size();
        for (int i = 0; i < sz; ++i) {
            PartitionDeltaProducer p = this.partitionDeltaProducerCache.getQuick(i);
            if (p == null) continue;
            p.free();
        }
    }

    @Override
    public boolean hasContent() {
        return this.journalServerState.notEmpty();
    }

    @Override
    public void write(WritableByteChannel channel) throws JournalNetworkException {
        this.journalServerStateProducer.write(channel, this.journalServerState);
        if (this.journalSymbolTableProducer.hasContent()) {
            this.journalSymbolTableProducer.write(channel);
        }
        int sz = this.partitionDeltaProducers.size();
        for (int i = 0; i < sz; ++i) {
            this.partitionDeltaProducers.getQuick(i).write(channel);
        }
        if (this.lagPartitionDeltaProducer != null && this.lagPartitionDeltaProducer.hasContent()) {
            this.lagPartitionDeltaProducer.write(channel);
        }
        this.journalServerState.reset();
        this.journal.expireOpenFiles0();
    }

    private void configure0(Tx tx) throws JournalException {
        long localRowID;
        int startPartitionIndex;
        if (LOG.isDebugEnabled()) {
            LOG.debug().$("Journal ").$(this.journal.getLocation()).$(" size: ").$(this.journal.size()).$();
        }
        this.journalSymbolTableProducer.configure(tx);
        this.journalServerState.setSymbolTables(this.journalSymbolTableProducer.hasContent());
        int nonLagPartitionCount = this.journal.nonLagPartitionCount();
        if (tx.journalMaxRowID == -1L) {
            startPartitionIndex = 0;
            localRowID = 0L;
            this.journalServerState.setNonLagPartitionCount(nonLagPartitionCount);
        } else {
            startPartitionIndex = Rows.toPartitionIndex(tx.journalMaxRowID);
            localRowID = Rows.toLocalRowID(tx.journalMaxRowID);
            if (startPartitionIndex < nonLagPartitionCount) {
                if (localRowID >= this.journal.getPartition(startPartitionIndex, true).size()) {
                    localRowID = 0L;
                    ++startPartitionIndex;
                }
                this.journalServerState.setNonLagPartitionCount(Math.max(0, nonLagPartitionCount - startPartitionIndex));
            } else {
                this.journalServerState.setNonLagPartitionCount(0);
            }
        }
        this.partitionDeltaProducers.clear();
        for (int i = startPartitionIndex; i < nonLagPartitionCount; ++i) {
            PartitionDeltaProducer producer = this.getPartitionDeltaProducer(i);
            producer.configure(localRowID);
            this.partitionDeltaProducers.add(producer);
            Partition partition = this.journal.getPartition(i, false);
            this.journalServerState.addPartitionMetadata(partition.getPartitionIndex(), partition.getInterval().getLo(), partition.getInterval().getHi(), (byte)(!producer.hasContent() ? 1 : 0));
            localRowID = 0L;
        }
        Partition lag = this.journal.getIrregularPartition();
        this.journalServerState.setLagPartitionName(null);
        if (lag != null) {
            if (this.lagPartitionDeltaProducer == null || this.lagPartitionDeltaProducer.getPartition() != lag) {
                this.lagPartitionDeltaProducer = new PartitionDeltaProducer(lag.open());
            }
            if (lag.getName().equals(tx.lagName)) {
                this.lagPartitionDeltaProducer.configure(tx.lagSize);
            } else {
                this.lagPartitionDeltaProducer.configure(0L);
            }
            if (this.lagPartitionDeltaProducer.hasContent()) {
                this.journalServerState.setLagPartitionName(lag.getName());
                this.journalServerState.setLagPartitionMetadata(lag.getPartitionIndex(), lag.getInterval().getLo(), lag.getInterval().getHi(), (byte)0);
            }
        } else if (tx.lagName != null) {
            this.journalServerState.setDetachLag(true);
        }
    }

    private PartitionDeltaProducer getPartitionDeltaProducer(int partitionIndex) throws JournalException {
        PartitionDeltaProducer producer = this.partitionDeltaProducerCache.getQuiet(partitionIndex);
        if (producer == null) {
            producer = new PartitionDeltaProducer(this.journal.getPartition(partitionIndex, true));
            this.partitionDeltaProducerCache.extendAndSet(partitionIndex, producer);
        }
        return producer;
    }
}

