/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.producer;

import com.questdb.net.ha.AbstractObjectProducer;
import com.questdb.net.ha.model.JournalServerState;
import com.questdb.std.ByteBuffers;
import java.nio.ByteBuffer;

public class JournalServerStateProducer
extends AbstractObjectProducer<JournalServerState> {
    private static final int SUMMARY_RECORD_SIZE = 21;

    @Override
    protected int getBufferSize(JournalServerState value) {
        return 21 + value.getNonLagPartitionCount() * 21 + 2 + (value.getLagPartitionName() != null ? 2 * value.getLagPartitionName().length() : 0) + 21;
    }

    @Override
    protected void write(JournalServerState value, ByteBuffer buffer) {
        buffer.putLong(value.getTxn());
        buffer.putLong(value.getTxPin());
        buffer.put((byte)(value.isSymbolTables() ? 1 : 0));
        buffer.putInt(value.getNonLagPartitionCount());
        for (int i = 0; i < value.getNonLagPartitionCount(); ++i) {
            JournalServerState.PartitionMetadata partitionMetadata = value.getMeta(i);
            buffer.putInt(partitionMetadata.getPartitionIndex());
            buffer.putLong(partitionMetadata.getIntervalStart());
            buffer.putLong(partitionMetadata.getIntervalEnd());
            buffer.put(partitionMetadata.getEmpty());
        }
        ByteBuffers.putStringW(buffer, value.getLagPartitionName());
        buffer.putInt(value.getLagPartitionMetadata().getPartitionIndex());
        buffer.putLong(value.getLagPartitionMetadata().getIntervalStart());
        buffer.putLong(value.getLagPartitionMetadata().getIntervalEnd());
        buffer.put(value.getLagPartitionMetadata().getEmpty());
    }
}

