/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.producer;

import com.questdb.net.ha.ChannelProducer;
import com.questdb.net.ha.producer.VariableColumnDeltaProducer;
import com.questdb.std.ByteBuffers;
import com.questdb.std.ObjList;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.store.Journal;
import com.questdb.store.MMappedSymbolTable;
import com.questdb.store.Tx;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class JournalSymbolTableProducer
implements ChannelProducer {
    private final ObjList<VariableColumnDeltaProducer> symbolTableProducers = new ObjList();
    private final ObjList<MMappedSymbolTable> symbolTables = new ObjList();
    private final ByteBuffer buffer;
    private boolean hasContent = false;

    public JournalSymbolTableProducer(Journal journal) {
        int tabCount = journal.getSymbolTableCount();
        for (int i = 0; i < tabCount; ++i) {
            MMappedSymbolTable tab = journal.getSymbolTable(i);
            this.symbolTables.add(tab);
            this.symbolTableProducers.add(new VariableColumnDeltaProducer(tab.getDataColumn()));
        }
        this.buffer = ByteBuffer.allocateDirect(journal.getMetadata().getColumnCount()).order(ByteOrder.LITTLE_ENDIAN);
    }

    public void configure(Tx tx) {
        this.hasContent = false;
        this.buffer.rewind();
        int k = this.symbolTables.size();
        for (int i = 0; i < k; ++i) {
            MMappedSymbolTable tab = this.symbolTables.getQuick(i);
            if (tab != null) {
                VariableColumnDeltaProducer p = this.symbolTableProducers.getQuick(i);
                p.configure(i < tx.symbolTableSizes.length ? (long)tx.symbolTableSizes[i] : 0L, tab.size());
                if (p.hasContent()) {
                    this.buffer.put((byte)1);
                    this.hasContent = true;
                    continue;
                }
                this.buffer.put((byte)0);
                continue;
            }
            this.buffer.put((byte)0);
        }
    }

    @Override
    public void free() {
        int k = this.symbolTableProducers.size();
        for (int i = 0; i < k; ++i) {
            this.symbolTableProducers.getQuick(i).free();
        }
        ByteBuffers.release(this.buffer);
    }

    @Override
    public boolean hasContent() {
        return this.hasContent;
    }

    @Override
    public void write(WritableByteChannel channel) throws JournalNetworkException {
        this.buffer.flip();
        ByteBuffers.copy(this.buffer, channel);
        int k = this.symbolTableProducers.size();
        for (int i = 0; i < k; ++i) {
            VariableColumnDeltaProducer p = this.symbolTableProducers.getQuick(i);
            if (p == null || !p.hasContent()) continue;
            p.write(channel);
        }
        this.hasContent = false;
    }
}

