/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.producer;

import com.questdb.net.ha.producer.ChannelProducerGroup;
import com.questdb.net.ha.producer.ColumnDeltaProducer;
import com.questdb.net.ha.producer.FixedColumnDeltaProducer;
import com.questdb.net.ha.producer.VariableColumnDeltaProducer;
import com.questdb.std.ObjList;
import com.questdb.std.ex.JournalException;
import com.questdb.std.ex.JournalNetworkException;
import com.questdb.store.AbstractColumn;
import com.questdb.store.Partition;
import com.questdb.store.VariableColumn;
import java.nio.channels.WritableByteChannel;

public class PartitionDeltaProducer
extends ChannelProducerGroup<ColumnDeltaProducer> {
    private final Partition partition;

    public PartitionDeltaProducer(Partition partition) {
        this.partition = partition;
        int c = partition.getJournal().getMetadata().getColumnCount();
        for (int i = 0; i < c; ++i) {
            AbstractColumn col = partition.getAbstractColumn(i);
            this.addProducer(col instanceof VariableColumn ? new VariableColumnDeltaProducer((VariableColumn)col) : new FixedColumnDeltaProducer(col));
        }
    }

    public void configure(long localRowID) throws JournalException {
        this.partition.open();
        long limit = this.partition.size();
        ObjList producers = this.getProducers();
        int sz = producers.size();
        for (int i = 0; i < sz; ++i) {
            ((ColumnDeltaProducer)producers.getQuick(i)).configure(localRowID, limit);
        }
        this.computeHasContent();
    }

    public Partition getPartition() {
        return this.partition;
    }

    @Override
    public void write(WritableByteChannel channel) throws JournalNetworkException {
        super.write(channel);
        try {
            this.partition.open();
        }
        catch (JournalException e) {
            throw new JournalNetworkException(e);
        }
    }
}

