/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.protocol;

import com.questdb.net.ha.ChannelProducer;
import com.questdb.std.ByteBuffers;
import com.questdb.std.ex.JournalNetworkException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class CommandProducer
implements ChannelProducer {
    private ByteBuffer buffer;

    @Override
    public void free() {
        this.buffer = ByteBuffers.release(this.buffer);
    }

    @Override
    public final boolean hasContent() {
        return this.buffer != null && this.buffer.hasRemaining();
    }

    @Override
    public final void write(WritableByteChannel channel) throws JournalNetworkException {
        ByteBuffers.copy(this.buffer, channel);
    }

    public void setCommand(byte command) {
        int sz = 3;
        int bufSz = sz + 4;
        if (this.buffer == null || this.buffer.capacity() < bufSz) {
            ByteBuffers.release(this.buffer);
            this.buffer = ByteBuffer.allocateDirect(bufSz).order(ByteOrder.LITTLE_ENDIAN);
        }
        this.buffer.limit(bufSz);
        this.buffer.rewind();
        this.buffer.putInt(sz);
        this.buffer.putChar('\ufafb');
        this.buffer.put(command);
        this.buffer.flip();
    }

    public final void write(WritableByteChannel channel, byte command) throws JournalNetworkException {
        this.setCommand(command);
        this.write(channel);
    }
}

