/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha.protocol.commands;

import com.questdb.net.ha.ChannelProducer;
import com.questdb.std.ByteBuffers;
import com.questdb.std.ex.JournalNetworkException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class IntResponseProducer
implements ChannelProducer {
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(4).order(ByteOrder.LITTLE_ENDIAN);

    @Override
    public void free() {
        ByteBuffers.release(this.buffer);
    }

    @Override
    public boolean hasContent() {
        return this.buffer.hasRemaining();
    }

    @Override
    public void write(WritableByteChannel channel) throws JournalNetworkException {
        ByteBuffers.copy(this.buffer, channel);
    }

    public void write(WritableByteChannel channel, int value) throws JournalNetworkException {
        this.setValue(value);
        this.write(channel);
    }

    private void setValue(int value) {
        this.buffer.rewind();
        this.buffer.putInt(value);
        this.buffer.flip();
    }
}

