/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http;

import com.questdb.BootstrapEnv;
import com.questdb.ServerConfiguration;
import com.questdb.common.JournalRuntimeException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.mp.Job;
import com.questdb.mp.MCSequence;
import com.questdb.mp.RingQueue;
import com.questdb.mp.SPSequence;
import com.questdb.mp.Sequence;
import com.questdb.mp.Worker;
import com.questdb.net.Context;
import com.questdb.net.ContextFactory;
import com.questdb.net.Dispatcher;
import com.questdb.net.EpollDispatcher;
import com.questdb.net.Event;
import com.questdb.net.KQueueDispatcher;
import com.questdb.net.NetworkChannelImpl;
import com.questdb.net.Win32SelectDispatcher;
import com.questdb.net.http.IOContext;
import com.questdb.net.http.IOHttpJob;
import com.questdb.net.http.UrlMatcher;
import com.questdb.std.Misc;
import com.questdb.std.ObjHashSet;
import com.questdb.std.ObjList;
import com.questdb.std.ObjectFactory;
import com.questdb.std.Os;
import com.questdb.std.ex.FatalError;
import com.questdb.std.ex.NetworkError;
import com.questdb.std.time.MillisecondClock;
import com.questdb.std.time.MillisecondClockImpl;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;

public class HttpServer {
    private static final Log LOG = LogFactory.getLog(HttpServer.class);
    private static final ObjectFactory<Event<IOContext>> EVENT_FACTORY = Event::new;
    private final InetSocketAddress address;
    private final ObjList<Worker> workers;
    private final CountDownLatch haltLatch;
    private final int workerCount;
    private final CountDownLatch startComplete = new CountDownLatch(1);
    private final UrlMatcher urlMatcher;
    private final ServerConfiguration configuration;
    private final ContextFactory<IOContext> contextFactory;
    private final ObjHashSet<Job> jobs = new ObjHashSet();
    private volatile boolean running = true;
    private MillisecondClock clock = MillisecondClockImpl.INSTANCE;
    private Dispatcher<IOContext> dispatcher;
    private RingQueue<Event<IOContext>> ioQueue;

    public HttpServer(BootstrapEnv env) {
        this.configuration = env.configuration;
        this.address = new InetSocketAddress(this.configuration.getHttpIP(), this.configuration.getHttpPort());
        this.urlMatcher = env.matcher;
        this.workerCount = this.configuration.getHttpThreads();
        this.haltLatch = new CountDownLatch(this.workerCount);
        this.workers = new ObjList(this.workerCount);
        this.contextFactory = (fd, clock) -> new IOContext(new NetworkChannelImpl(fd), this.configuration, clock);
    }

    public ObjHashSet<Job> getJobs() {
        return this.jobs;
    }

    public void halt() {
        if (this.running) {
            int i;
            this.running = false;
            try {
                this.startComplete.await();
                for (i = 0; i < this.workers.size(); ++i) {
                    this.workers.getQuick(i).halt();
                }
                this.haltLatch.await();
                this.dispatcher.close();
            }
            catch (Exception e) {
                throw new JournalRuntimeException(e);
            }
            for (i = 0; i < this.ioQueue.getCapacity(); ++i) {
                Event<IOContext> ev = this.ioQueue.get(i);
                if (ev == null || ev.context == null) continue;
                ev.context = (Context)Misc.free(ev.context);
            }
        }
    }

    public void setClock(MillisecondClock clock) {
        this.clock = clock;
    }

    public boolean start() {
        this.running = true;
        this.ioQueue = new RingQueue<Event<IOContext>>(EVENT_FACTORY, this.configuration.getHttpQueueDepth());
        SPSequence ioPubSequence = new SPSequence(this.ioQueue.getCapacity());
        MCSequence ioSubSequence = new MCSequence(this.ioQueue.getCapacity(), null);
        ioPubSequence.then(ioSubSequence).then(ioPubSequence);
        try {
            this.dispatcher = this.createDispatcher(this.address.getHostName(), this.address.getPort(), this.ioQueue, ioPubSequence, this.clock, this.configuration);
        }
        catch (NetworkError e) {
            LOG.error().$("Server failed to start: ").$(e.getMessage()).$();
            this.running = false;
            return false;
        }
        this.jobs.add(this.dispatcher);
        this.jobs.add(new IOHttpJob(this.ioQueue, ioSubSequence, this.dispatcher, this.urlMatcher));
        for (int i = 0; i < this.workerCount; ++i) {
            Worker w = new Worker(this.jobs, this.haltLatch);
            this.workers.add(w);
            w.start();
        }
        this.startComplete.countDown();
        LOG.info().$("Server is running").$();
        return true;
    }

    private Dispatcher<IOContext> createDispatcher(CharSequence ip, int port, RingQueue<Event<IOContext>> ioQueue, Sequence ioSequence, MillisecondClock clock, ServerConfiguration configuration) {
        switch (Os.type) {
            case 1: {
                return new KQueueDispatcher<IOContext>(ip, port, configuration.getHttpMaxConnections(), configuration.getHttpTimeout(), ioQueue, ioSequence, clock, configuration.getHttpQueueDepth(), EVENT_FACTORY, this.contextFactory);
            }
            case 3: {
                return new Win32SelectDispatcher<IOContext>(ip, port, configuration.getHttpMaxConnections(), configuration.getHttpTimeout(), ioQueue, ioSequence, clock, configuration.getHttpQueueDepth(), EVENT_FACTORY, this.contextFactory);
            }
            case 2: {
                return new EpollDispatcher<IOContext>(ip, port, configuration.getHttpMaxConnections(), configuration.getHttpTimeout(), ioQueue, ioSequence, clock, configuration.getHttpQueueDepth(), EVENT_FACTORY, this.contextFactory);
            }
        }
        throw new FatalError("Unsupported operating system");
    }

    int getConnectionCount() {
        return this.dispatcher.getConnectionCount();
    }
}

