/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http;

import com.questdb.ServerConfiguration;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.net.Context;
import com.questdb.net.NonBlockingSecureSocketChannel;
import com.questdb.net.http.ChunkedResponse;
import com.questdb.net.http.FixedSizeResponse;
import com.questdb.net.http.Request;
import com.questdb.net.http.Response;
import com.questdb.net.http.ResponseSink;
import com.questdb.net.http.SimpleResponse;
import com.questdb.std.LocalValueMap;
import com.questdb.std.Locality;
import com.questdb.std.Misc;
import com.questdb.std.Mutable;
import com.questdb.std.NetworkChannel;
import com.questdb.std.ex.DisconnectedChannelException;
import com.questdb.std.ex.SlowWritableChannelException;
import com.questdb.std.time.MillisecondClock;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;

public class IOContext
implements Closeable,
Mutable,
Locality,
Context {
    private static final Log LOG = LogFactory.getLog(IOContext.class);
    public final NetworkChannel channel;
    public final Request request;
    private final ServerConfiguration serverConfiguration;
    private final LocalValueMap map = new LocalValueMap();
    private final Response response;
    private final AtomicBoolean open = new AtomicBoolean(true);

    public IOContext(NetworkChannel channel, ServerConfiguration configuration, MillisecondClock clock) {
        this.channel = configuration.getSslConfig().isSecure() ? new NonBlockingSecureSocketChannel(channel, configuration.getSslConfig()) : channel;
        this.serverConfiguration = configuration;
        this.request = new Request(this.channel, configuration);
        this.response = new Response(this.channel, configuration, clock);
    }

    public ChunkedResponse chunkedResponse() {
        return this.response.asChunked();
    }

    @Override
    public void clear() {
        this.request.clear();
        this.response.clear();
        this.map.clear();
    }

    @Override
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            LOG.debug().$("Releasing context for ").$ip(this.channel.getIp()).$();
            Misc.free(this.map);
            Misc.free(this.channel);
            Misc.free(this.request);
            Misc.free(this.response);
            LOG.debug().$("Released context for ").$ip(this.channel.getIp()).$();
        }
    }

    public SimpleResponse emergencyResponse() {
        this.response.clear();
        return this.response.asSimple();
    }

    public FixedSizeResponse fixedSizeResponse() {
        return this.response.asFixedSize();
    }

    @Override
    public long getFd() {
        return this.channel.getFd();
    }

    @Override
    public long getIp() {
        return this.channel.getIp();
    }

    @Override
    public LocalValueMap getMap() {
        return this.map;
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public ResponseSink responseSink() {
        return this.response.asSink();
    }

    public void resume() throws DisconnectedChannelException, SlowWritableChannelException {
        this.response.resume();
    }

    public SimpleResponse simpleResponse() {
        return this.response.asSimple();
    }

    int getResponseCode() {
        return this.response.getCode();
    }
}

