/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http;

import com.questdb.ex.DisconnectedChannelRuntimeException;
import com.questdb.ex.HeadersTooLargeException;
import com.questdb.ex.MalformedHeaderException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.mp.Job;
import com.questdb.mp.RingQueue;
import com.questdb.mp.Sequence;
import com.questdb.net.Dispatcher;
import com.questdb.net.Event;
import com.questdb.net.http.ContextHandler;
import com.questdb.net.http.IOContext;
import com.questdb.net.http.MultipartListener;
import com.questdb.net.http.Request;
import com.questdb.net.http.SimpleResponse;
import com.questdb.net.http.UrlMatcher;
import com.questdb.std.ex.DisconnectedChannelException;
import com.questdb.std.ex.EndOfChannelException;
import com.questdb.std.ex.SlowReadableChannelException;
import com.questdb.std.ex.SlowWritableChannelException;
import java.io.IOException;

public class IOHttpJob
implements Job {
    public static final int SO_WRITE_RETRY_COUNT = 1000;
    private static final Log ACCESS = LogFactory.getLog("access");
    private static final Log LOG = LogFactory.getLog(IOHttpJob.class);
    private final RingQueue<Event<IOContext>> ioQueue;
    private final Sequence ioSequence;
    private final Dispatcher<IOContext> ioDispatcher;
    private final UrlMatcher urlMatcher;

    IOHttpJob(RingQueue<Event<IOContext>> ioQueue, Sequence ioSequence, Dispatcher<IOContext> ioDispatcher, UrlMatcher urlMatcher) {
        this.ioQueue = ioQueue;
        this.ioSequence = ioSequence;
        this.ioDispatcher = ioDispatcher;
        this.urlMatcher = urlMatcher;
    }

    @Override
    public boolean run() {
        long cursor = this.ioSequence.next();
        if (cursor < 0L) {
            return false;
        }
        Event<IOContext> evt = this.ioQueue.get(cursor);
        IOContext ioContext = (IOContext)evt.context;
        int status = evt.channelStatus;
        this.ioSequence.done(cursor);
        this.process(ioContext, status);
        return true;
    }

    @Override
    public void setupThread() {
        this.ioDispatcher.setupThread();
        this.urlMatcher.setupHandlers();
    }

    private static void logAccess(IOContext context) {
        ACCESS.xinfo().$ip(context.channel.getIp()).$(" -").$(" -").$(" [").$ts(System.currentTimeMillis()).$("] ").$('\"').$(context.request.getMethodLine()).$('\"').$(' ').$(context.getResponseCode()).$(' ').$(context.channel.getTotalWrittenAndReset()).$();
    }

    private void process(IOContext context, int channelStatus) {
        int newChannelStatus;
        Request r = context.request;
        SimpleResponse sr = context.simpleResponse();
        try {
            boolean log = r.isIncomplete();
            if (channelStatus == 1) {
                r.read();
            }
            if (r.getUrl() == null) {
                sr.send(400);
            } else {
                ContextHandler handler = this.urlMatcher.get(r.getUrl());
                if (handler != null) {
                    switch (channelStatus) {
                        case 4: {
                            context.resume();
                            handler.resume(context);
                            break;
                        }
                        case 1: {
                            if (r.isMultipart()) {
                                if (handler instanceof MultipartListener) {
                                    r.parseMultipart(context, (MultipartListener)((Object)handler));
                                    handler.handle(context);
                                    break;
                                }
                                sr.send(400);
                                break;
                            }
                            if (handler instanceof MultipartListener) {
                                sr.send(400);
                                break;
                            }
                            handler.handle(context);
                            break;
                        }
                        default: {
                            LOG.error().$("Unexpected status: ").$(channelStatus).$();
                            break;
                        }
                    }
                } else {
                    sr.send(404);
                }
                if (log && !r.isIncomplete()) {
                    IOHttpJob.logAccess(context);
                }
            }
            context.clear();
            newChannelStatus = 1;
        }
        catch (HeadersTooLargeException ignored) {
            this.silent(context, 431, null);
            LOG.info().$("Headers too large").$();
            IOHttpJob.logAccess(context);
            newChannelStatus = 1;
        }
        catch (DisconnectedChannelRuntimeException | MalformedHeaderException | DisconnectedChannelException e) {
            newChannelStatus = 3;
        }
        catch (EndOfChannelException e) {
            newChannelStatus = 5;
        }
        catch (SlowReadableChannelException e) {
            LOG.debug().$("Slow read").$();
            newChannelStatus = 1;
        }
        catch (SlowWritableChannelException e) {
            LOG.debug().$("Slow write").$();
            newChannelStatus = 4;
        }
        catch (Throwable e) {
            context.clear();
            this.silent(context, 500, e.getMessage());
            newChannelStatus = 3;
            LOG.error().$("Internal error: ").$(e).$();
            IOHttpJob.logAccess(context);
        }
        this.ioDispatcher.registerChannel(context, newChannelStatus);
    }

    private void silent(IOContext context, int code, CharSequence msg) {
        try {
            context.emergencyResponse().send(code, msg);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

