/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http;

import com.questdb.std.ByteBuffers;
import com.questdb.std.CharSequenceObjHashMap;
import com.questdb.std.Unsafe;
import com.questdb.std.str.DirectByteCharSequence;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class MimeTypes
extends CharSequenceObjHashMap<CharSequence> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimeTypes(File file) throws IOException {
        DirectByteCharSequence dbcs = new DirectByteCharSequence();
        try (FileInputStream fis = new FileInputStream(file);){
            int sz = fis.available();
            ByteBuffer buf = ByteBuffer.allocateDirect(sz);
            try {
                fis.getChannel().read(buf);
                long p = ByteBuffers.getAddress(buf);
                long hi = p + (long)sz;
                long _lo = p;
                boolean newline = true;
                boolean comment = false;
                String contentType = null;
                block17: while (p < hi) {
                    char b = (char)Unsafe.getUnsafe().getByte(p++);
                    switch (b) {
                        case '#': {
                            comment = newline;
                            continue block17;
                        }
                        case '\t': 
                        case ' ': {
                            if (comment) continue block17;
                            if (newline || _lo == p - 1L) {
                                _lo = p;
                                continue block17;
                            }
                            String s = dbcs.of(_lo, p - 1L).toString();
                            _lo = p;
                            if (contentType == null) {
                                contentType = s;
                            } else {
                                this.put(s, contentType);
                            }
                            newline = false;
                            continue block17;
                        }
                        case '\n': 
                        case '\r': {
                            String s;
                            newline = true;
                            comment = false;
                            if (_lo < p - 1L && contentType != null) {
                                s = dbcs.of(_lo, p - 1L).toString();
                                this.put(s, contentType);
                            }
                            contentType = null;
                            _lo = p;
                            continue block17;
                        }
                    }
                    if (!newline) continue;
                    newline = false;
                }
            }
            finally {
                ByteBuffers.release(buf);
            }
        }
    }
}

