/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http;

import com.questdb.ex.HeadersTooLargeException;
import com.questdb.ex.MalformedHeaderException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.net.http.IOContext;
import com.questdb.net.http.MultipartListener;
import com.questdb.net.http.RequestHeaderBuffer;
import com.questdb.std.Mutable;
import com.questdb.std.ObjectPool;
import com.questdb.std.Unsafe;
import com.questdb.std.str.DirectByteCharSequence;
import java.io.Closeable;
import java.io.IOException;

public class MultipartParser
implements Closeable,
Mutable {
    private static final int START_PARSING = 1;
    private static final int START_BOUNDARY = 2;
    private static final int PARTIAL_START_BOUNDARY = 3;
    private static final int HEADERS = 4;
    private static final int PARTIAL_HEADERS = 5;
    private static final int BODY = 6;
    private static final int BODY_CONTINUED = 7;
    private static final int BODY_BROKEN = 8;
    private static final int POTENTIAL_BOUNDARY = 9;
    private static final int PRE_HEADERS = 10;
    private static final int BOUNDARY_MATCH = 1;
    private static final int BOUNDARY_NO_MATCH = 2;
    private static final int BOUNDARY_INCOMPLETE = 3;
    private final Log LOG = LogFactory.getLog(MultipartParser.class);
    private final RequestHeaderBuffer hb;
    private final DirectByteCharSequence bytes = new DirectByteCharSequence();
    private DirectByteCharSequence boundary;
    private int boundaryLen;
    private int boundaryPtr;
    private int consumedBoundaryLen;
    private int state;

    public MultipartParser(int headerBufSize, ObjectPool<DirectByteCharSequence> pool) {
        this.hb = new RequestHeaderBuffer(headerBufSize, pool);
        this.clear();
    }

    @Override
    public final void clear() {
        this.state = 1;
        this.boundaryPtr = 0;
        this.consumedBoundaryLen = 0;
        this.hb.clear();
    }

    @Override
    public void close() {
        this.hb.close();
    }

    public MultipartParser of(DirectByteCharSequence boundary) {
        this.boundary = boundary;
        this.boundaryLen = boundary.length();
        return this;
    }

    public boolean parse(IOContext context, long ptr, int len, MultipartListener listener) throws HeadersTooLargeException, MalformedHeaderException, IOException {
        long hi = ptr + (long)len;
        long _lo = Long.MAX_VALUE;
        block29: while (ptr < hi) {
            switch (this.state) {
                case 8: {
                    _lo = ptr;
                    this.state = 7;
                    continue block29;
                }
                case 1: {
                    listener.setup(context);
                    this.state = 2;
                }
                case 2: {
                    this.boundaryPtr = 2;
                }
                case 3: {
                    switch (this.matchBoundary(ptr, hi)) {
                        case 3: {
                            this.state = 3;
                            return false;
                        }
                        case 1: {
                            this.state = 10;
                            ptr += (long)this.consumedBoundaryLen;
                            continue block29;
                        }
                    }
                    this.LOG.error().$("Malformed start boundary").$();
                    throw MalformedHeaderException.INSTANCE;
                }
                case 10: {
                    switch (Unsafe.getUnsafe().getByte(ptr)) {
                        case 10: {
                            this.state = 4;
                        }
                        case 13: {
                            ++ptr;
                            continue block29;
                        }
                        case 45: {
                            return true;
                        }
                    }
                    _lo = ptr;
                    this.state = 7;
                    continue block29;
                }
                case 4: {
                    this.hb.clear();
                }
                case 5: {
                    ptr = this.hb.write(ptr, (int)(hi - ptr), false);
                    if (this.hb.isIncomplete()) {
                        this.state = 5;
                        return false;
                    }
                    _lo = ptr;
                    this.state = 6;
                    continue block29;
                }
                case 6: 
                case 7: {
                    char b = (char)Unsafe.getUnsafe().getByte(ptr++);
                    if (b != this.boundary.charAt(0)) continue block29;
                    this.boundaryPtr = 1;
                    switch (this.matchBoundary(ptr, hi)) {
                        case 3: {
                            listener.onChunk(context, this.hb, this.bytes.of(_lo, ptr - 1L), this.state == 7);
                            this.state = 9;
                            return false;
                        }
                        case 1: {
                            listener.onChunk(context, this.hb, this.bytes.of(_lo, ptr - 1L), this.state == 7);
                            this.state = 10;
                            ptr += (long)this.consumedBoundaryLen;
                            continue block29;
                        }
                    }
                    continue block29;
                }
                case 9: {
                    int p = this.boundaryPtr;
                    switch (this.matchBoundary(ptr, hi)) {
                        case 3: {
                            return false;
                        }
                        case 1: {
                            ptr += (long)this.consumedBoundaryLen;
                            this.state = 10;
                            continue block29;
                        }
                        case 2: {
                            listener.onChunk(context, this.hb, this.bytes.of(this.boundary.getLo(), this.boundary.getLo() + (long)p), true);
                            this.state = 8;
                            continue block29;
                        }
                    }
                    continue block29;
                }
            }
        }
        if (this.state == 6 || this.state == 7) {
            listener.onChunk(context, this.hb, this.bytes.of(_lo, ptr), this.state == 7);
            this.state = 8;
        }
        return false;
    }

    private int matchBoundary(long lo, long hi) {
        long start = lo;
        int ptr = this.boundaryPtr;
        while (lo < hi && ptr < this.boundaryLen) {
            if (Unsafe.getUnsafe().getByte(lo++) == this.boundary.byteAt(ptr++)) continue;
            return 2;
        }
        this.boundaryPtr = ptr;
        if (this.boundaryPtr < this.boundaryLen) {
            return 3;
        }
        this.consumedBoundaryLen = (int)(lo - start);
        return 1;
    }
}

