/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http;

import com.questdb.common.NumericException;
import com.questdb.std.Chars;
import com.questdb.std.Numbers;
import com.questdb.std.ObjectFactory;

public class RangeParser {
    public static final ObjectFactory<RangeParser> FACTORY = RangeParser::new;
    private static final String BYTES = "bytes=";
    private long lo;
    private long hi;

    private RangeParser() {
    }

    public long getHi() {
        return this.hi;
    }

    public long getLo() {
        return this.lo;
    }

    public boolean of(CharSequence range) {
        if (!Chars.startsWith(range, BYTES)) {
            return false;
        }
        int n = Chars.indexOf(range, BYTES.length(), '-');
        if (n == -1) {
            return false;
        }
        try {
            this.lo = Numbers.parseLong(range, BYTES.length(), n);
            this.hi = n == range.length() - 1 ? Long.MAX_VALUE : Numbers.parseLong(range, n + 1, range.length());
            return true;
        }
        catch (NumericException e) {
            return false;
        }
    }
}

