/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http;

import com.questdb.ServerConfiguration;
import com.questdb.ex.HeadersTooLargeException;
import com.questdb.ex.MalformedHeaderException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.net.http.IOContext;
import com.questdb.net.http.MultipartListener;
import com.questdb.net.http.MultipartParser;
import com.questdb.net.http.RequestHeaderBuffer;
import com.questdb.std.ByteBuffers;
import com.questdb.std.Chars;
import com.questdb.std.Mutable;
import com.questdb.std.Net;
import com.questdb.std.NetworkChannel;
import com.questdb.std.Numbers;
import com.questdb.std.ObjectPool;
import com.questdb.std.Unsafe;
import com.questdb.std.str.DirectByteCharSequence;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Request
implements Closeable,
Mutable {
    private static final Log LOG = LogFactory.getLog(Request.class);
    private final ByteBuffer in;
    private final long inAddr;
    private final ObjectPool<DirectByteCharSequence> pool = new ObjectPool<DirectByteCharSequence>(DirectByteCharSequence.FACTORY, 64);
    private final RequestHeaderBuffer hb;
    private final MultipartParser multipartParser;
    private final BoundaryAugmenter augmenter = new BoundaryAugmenter();
    private final NetworkChannel channel;
    private final int soRcvSmall;
    private final int soRcvLarge;
    private final int soRetries;

    public Request(NetworkChannel channel, ServerConfiguration configuration) {
        this.channel = channel;
        this.hb = new RequestHeaderBuffer(configuration.getHttpBufReqHeader(), this.pool);
        this.in = ByteBuffer.allocateDirect(Numbers.ceilPow2(configuration.getHttpBufReqContent()));
        this.inAddr = ByteBuffers.getAddress(this.in);
        this.multipartParser = new MultipartParser(configuration.getHttpBufReqMultipart(), this.pool);
        this.soRcvSmall = configuration.getHttpSoRcvSmall();
        this.soRcvLarge = configuration.getHttpSoRcvLarge();
        this.soRetries = configuration.getHttpSoRetries();
    }

    @Override
    public void clear() {
        this.hb.clear();
        this.pool.clear();
        this.in.clear();
        this.multipartParser.clear();
    }

    @Override
    public void close() {
        this.hb.close();
        this.multipartParser.close();
        ByteBuffers.release(this.in);
        this.augmenter.close();
    }

    public CharSequence getHeader(CharSequence name) {
        return this.hb.get(name);
    }

    public CharSequence getMethodLine() {
        return this.hb.getMethodLine();
    }

    public CharSequence getUrl() {
        return this.hb.getUrl();
    }

    public CharSequence getUrlParam(CharSequence name) {
        return this.hb.getUrlParam(name);
    }

    public boolean isIncomplete() {
        return this.hb.isIncomplete();
    }

    public boolean isMultipart() {
        return Chars.equalsNc("multipart/form-data", this.hb.getContentType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseMultipart(IOContext context, MultipartListener handler) throws HeadersTooLargeException, IOException, MalformedHeaderException {
        long fd = this.channel.getFd();
        if (Net.setRcvBuf(fd, this.soRcvLarge) != 0) {
            LOG.error().$("Could not set SO_RCVBUF on ").$(fd).$();
        }
        try {
            int sz;
            MultipartParser parser = this.getMultipartParser().of(this.getBoundary());
            while ((sz = this.in.remaining()) <= 0 || !parser.parse(context, ByteBuffers.getAddress(this.in) + (long)this.in.position(), sz, handler)) {
                this.drainChannel();
            }
        }
        finally {
            if (Net.setRcvBuf(fd, this.soRcvSmall) != 0) {
                LOG.error().$("Could not reset SO_RCVBUF on ").$(fd).$();
            }
        }
    }

    public void read() throws HeadersTooLargeException, IOException, MalformedHeaderException {
        this.drainChannel();
        if (this.isIncomplete()) {
            this.readHeaders();
        }
    }

    private void drainChannel() throws IOException {
        this.in.clear();
        ByteBuffers.copyNonBlocking(this.channel, this.in, this.soRetries);
        this.in.flip();
    }

    private DirectByteCharSequence getBoundary() {
        return this.augmenter.of(this.hb.getBoundary());
    }

    private MultipartParser getMultipartParser() {
        return this.multipartParser;
    }

    private void readHeaders() throws HeadersTooLargeException, IOException, MalformedHeaderException {
        while (true) {
            this.in.position((int)(this.hb.write(this.inAddr, this.in.remaining(), true) - this.inAddr));
            if (!this.hb.isIncomplete()) break;
            this.drainChannel();
        }
    }

    public static class BoundaryAugmenter
    implements Closeable {
        private static final String BOUNDARY_PREFIX = "\r\n--";
        private final DirectByteCharSequence export = new DirectByteCharSequence();
        private long lo = this._wptr = Unsafe.malloc(this.lim);
        private long lim = 64L;
        private long _wptr;

        public BoundaryAugmenter() {
            this.of0(BOUNDARY_PREFIX);
        }

        public DirectByteCharSequence of(CharSequence value) {
            int len = value.length() + BOUNDARY_PREFIX.length();
            if ((long)len > this.lim) {
                this.resize(len);
            }
            this._wptr = this.lo + (long)BOUNDARY_PREFIX.length();
            this.of0(value);
            return this.export.of(this.lo, this._wptr);
        }

        private void of0(CharSequence value) {
            int len = value.length();
            Chars.strcpy(value, len, this._wptr);
            this._wptr += (long)len;
        }

        private void resize(int lim) {
            Unsafe.free(this.lo, this.lim);
            this.lim = Numbers.ceilPow2(lim);
            this.lo = this._wptr = Unsafe.malloc(this.lim);
            this.of0(BOUNDARY_PREFIX);
        }

        @Override
        public void close() {
            if (this.lo > 0L) {
                Unsafe.free(this.lo, this.lim);
                this.lo = 0L;
            }
        }
    }
}

