/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http;

import com.questdb.ex.HeadersTooLargeException;
import com.questdb.ex.MalformedHeaderException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.CharSequenceObjHashMap;
import com.questdb.std.Chars;
import com.questdb.std.Misc;
import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.ObjectPool;
import com.questdb.std.Unsafe;
import com.questdb.std.str.DirectByteCharSequence;
import java.io.Closeable;

public class RequestHeaderBuffer
implements Mutable,
Closeable {
    private static final Log LOG = LogFactory.getLog(RequestHeaderBuffer.class);
    private final ObjectPool<DirectByteCharSequence> pool;
    private final CharSequenceObjHashMap<CharSequence> headers = new CharSequenceObjHashMap();
    private final CharSequenceObjHashMap<CharSequence> urlParams = new CharSequenceObjHashMap();
    private final long hi;
    private long _wptr;
    private long headerPtr;
    private CharSequence method;
    private CharSequence url;
    private CharSequence methodLine;
    private boolean needMethod;
    private long _lo;
    private CharSequence n;
    private boolean incomplete;
    private CharSequence contentType;
    private CharSequence boundary;
    private CharSequence contentDispositionName;
    private CharSequence contentDispositionFilename;
    private boolean m = true;
    private boolean u = true;
    private boolean q = false;

    public RequestHeaderBuffer(int size, ObjectPool<DirectByteCharSequence> pool) {
        int sz = Numbers.ceilPow2(size);
        this._wptr = this.headerPtr = Unsafe.malloc(sz);
        this.hi = this.headerPtr + (long)sz;
        this.pool = pool;
        this.clear();
    }

    @Override
    public final void clear() {
        this.needMethod = true;
        this._wptr = this._lo = this.headerPtr;
        this.incomplete = true;
        this.headers.clear();
        this.method = null;
        this.url = null;
        this.n = null;
        this.contentType = null;
        this.boundary = null;
        this.contentDispositionName = null;
        this.contentDispositionFilename = null;
        this.urlParams.clear();
        this.m = true;
        this.u = true;
        this.q = false;
    }

    @Override
    public void close() {
        if (this.headerPtr != 0L) {
            Unsafe.free(this.headerPtr, this.hi - this.headerPtr);
            this.headerPtr = 0L;
        }
    }

    public CharSequence get(CharSequence name) {
        return this.headers.get(name);
    }

    public CharSequence getBoundary() {
        return this.boundary;
    }

    public CharSequence getContentDispositionFilename() {
        return this.contentDispositionFilename;
    }

    public CharSequence getContentDispositionName() {
        return this.contentDispositionName;
    }

    public CharSequence getContentType() {
        return this.contentType;
    }

    public CharSequence getMethod() {
        return this.method;
    }

    public CharSequence getMethodLine() {
        return this.methodLine;
    }

    public CharSequence getUrl() {
        return this.url;
    }

    public CharSequence getUrlParam(CharSequence name) {
        return this.urlParams.get(name);
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public int size() {
        return this.headers.size();
    }

    public long write(long ptr, int len, boolean _method) throws HeadersTooLargeException, MalformedHeaderException {
        if (_method && this.needMethod) {
            int l = this.parseMethod(ptr, len);
            len -= l;
            ptr += (long)l;
        }
        long p = ptr;
        long hi = p + (long)len;
        while (p < hi) {
            if (this._wptr == this.hi) {
                throw HeadersTooLargeException.INSTANCE;
            }
            char b = (char)Unsafe.getUnsafe().getByte(p++);
            if (b == '\r') continue;
            Unsafe.getUnsafe().putByte(this._wptr++, (byte)b);
            switch (b) {
                case ':': {
                    if (this.n != null) break;
                    this.n = this.pool.next().of(this._lo, this._wptr - 1L);
                    this._lo = this._wptr + 1L;
                    break;
                }
                case '\n': {
                    if (this.n == null) {
                        this.incomplete = false;
                        this.parseKnownHeaders();
                        return p;
                    }
                    DirectByteCharSequence v = this.pool.next().of(this._lo, this._wptr - 1L);
                    this._lo = this._wptr;
                    this.headers.put(this.n, v);
                    this.n = null;
                    break;
                }
            }
        }
        return p;
    }

    private static DirectByteCharSequence unquote(DirectByteCharSequence that) throws MalformedHeaderException {
        int len = that.length();
        if (len == 0) {
            LOG.error().$("Zero-length mandatory field").$();
            throw MalformedHeaderException.INSTANCE;
        }
        if (that.charAt(0) == '\"') {
            if (that.charAt(len - 1) == '\"') {
                return that.of(that.getLo() + 1L, that.getHi() - 1L);
            }
            LOG.error().$("Unclosed quote").$();
            throw MalformedHeaderException.INSTANCE;
        }
        return that;
    }

    private void parseContentDisposition() throws MalformedHeaderException {
        long p;
        CharSequence contentDisposition = this.get("Content-Disposition");
        if (contentDisposition == null) {
            return;
        }
        long _lo = p = ((DirectByteCharSequence)contentDisposition).getLo();
        long hi = ((DirectByteCharSequence)contentDisposition).getHi();
        boolean expectFormData = true;
        boolean swallowSpace = true;
        DirectByteCharSequence name = null;
        while (p <= hi) {
            char b = (char)Unsafe.getUnsafe().getByte(p++);
            if (b == ' ' && swallowSpace) {
                _lo = p;
                continue;
            }
            if (p > hi || b == ';') {
                if (expectFormData) {
                    _lo = p;
                    expectFormData = false;
                    continue;
                }
                if (name == null) {
                    LOG.error().$("Malformed content-disposition header").$();
                    throw MalformedHeaderException.INSTANCE;
                }
                if (Chars.equals((CharSequence)"name", name)) {
                    this.contentDispositionName = RequestHeaderBuffer.unquote(this.pool.next().of(_lo, p - 1L));
                    swallowSpace = true;
                    _lo = p;
                    continue;
                }
                if (Chars.equals((CharSequence)"filename", name)) {
                    this.contentDispositionFilename = RequestHeaderBuffer.unquote(this.pool.next().of(_lo, p - 1L));
                    _lo = p;
                    continue;
                }
                if (p <= hi) continue;
                break;
            }
            if (b != '=') continue;
            name = name == null ? this.pool.next().of(_lo, p - 1L) : name.of(_lo, p - 1L);
            _lo = p;
            swallowSpace = false;
        }
    }

    private void parseContentType() throws MalformedHeaderException {
        long p;
        CharSequence seq = this.get("Content-Type");
        if (seq == null) {
            return;
        }
        long _lo = p = ((DirectByteCharSequence)seq).getLo();
        long hi = ((DirectByteCharSequence)seq).getHi();
        DirectByteCharSequence name = null;
        boolean contentType = true;
        boolean swallowSpace = true;
        while (p <= hi) {
            char b = (char)Unsafe.getUnsafe().getByte(p++);
            if (b == ' ' && swallowSpace) {
                _lo = p;
                continue;
            }
            if (p > hi || b == ';') {
                if (contentType) {
                    this.contentType = this.pool.next().of(_lo, p - 1L);
                    _lo = p;
                    contentType = false;
                    continue;
                }
                if (name == null) {
                    LOG.error().$("Malformed content-type header").$();
                    throw MalformedHeaderException.INSTANCE;
                }
                if (Chars.equals((CharSequence)"encoding", name)) {
                    _lo = p;
                    continue;
                }
                if (Chars.equals((CharSequence)"boundary", name)) {
                    this.boundary = this.pool.next().of(_lo, p - 1L);
                    _lo = p;
                    continue;
                }
                if (p <= hi) continue;
                break;
            }
            if (b != '=') continue;
            name = name == null ? this.pool.next().of(_lo, p - 1L) : name.of(_lo, p - 1L);
            _lo = p;
            swallowSpace = false;
        }
    }

    private void parseKnownHeaders() throws MalformedHeaderException {
        this.parseContentType();
        this.parseContentDisposition();
    }

    private int parseMethod(long lo, int len) throws HeadersTooLargeException {
        long p = lo;
        long hi = lo + (long)len;
        while (p < hi) {
            if (this._wptr == this.hi) {
                throw HeadersTooLargeException.INSTANCE;
            }
            char b = (char)Unsafe.getUnsafe().getByte(p++);
            if (b == '\r') continue;
            switch (b) {
                case ' ': {
                    if (this.m) {
                        this.method = this.pool.next().of(this._lo, this._wptr);
                        this._lo = this._wptr + 1L;
                        this.m = false;
                        break;
                    }
                    if (this.u) {
                        this.url = this.pool.next().of(this._lo, this._wptr);
                        this.u = false;
                        this._lo = this._wptr + 1L;
                        break;
                    }
                    if (!this.q) break;
                    int o = Misc.urlDecode(this._lo, this._wptr, this.urlParams, this.pool);
                    this.q = false;
                    this._lo = this._wptr;
                    this._wptr -= (long)o;
                    break;
                }
                case '?': {
                    this.url = this.pool.next().of(this._lo, this._wptr);
                    this.u = false;
                    this.q = true;
                    this._lo = this._wptr + 1L;
                    break;
                }
                case '\n': {
                    this.methodLine = this.pool.next().of(((DirectByteCharSequence)this.method).getLo(), this._wptr);
                    this.needMethod = false;
                    this._lo = this._wptr;
                    return (int)(p - lo);
                }
            }
            Unsafe.getUnsafe().putByte(this._wptr++, (byte)b);
        }
        return (int)(p - lo);
    }
}

