/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http;

import com.questdb.ServerConfiguration;
import com.questdb.ex.ResponseContentBufferTooSmallException;
import com.questdb.ex.ZLibException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.log.LogRecord;
import com.questdb.net.NonBlockingSecureSocketChannel;
import com.questdb.net.http.ChunkedResponse;
import com.questdb.net.http.FixedSizeResponse;
import com.questdb.net.http.ResponseHeaderBuffer;
import com.questdb.net.http.ResponseSink;
import com.questdb.net.http.SimpleResponse;
import com.questdb.std.ByteBuffers;
import com.questdb.std.Chars;
import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import com.questdb.std.Zip;
import com.questdb.std.ex.DisconnectedChannelException;
import com.questdb.std.ex.SlowWritableChannelException;
import com.questdb.std.str.AbstractCharSink;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.DirectUnboundedByteSink;
import com.questdb.std.time.MillisecondClock;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class Response
implements Closeable,
Mutable {
    private static final Log LOG = LogFactory.getLog(Response.class);
    private static final int CHUNK_HEAD = 1;
    private static final int CHUNK_DATA = 2;
    private static final int FIN = 3;
    private static final int MULTI_CHUNK = 4;
    private static final int DEFLATE = 5;
    private static final int MULTI_BUF_CHUNK = 6;
    private static final int END_CHUNK = 7;
    private static final int DONE = 8;
    private static final int FLUSH = 9;
    private static final int SEND_DEFLATED_CONT = 10;
    private static final int SEND_DEFLATED_END = 11;
    private final ByteBuffer out;
    private final long outPtr;
    private final long limit;
    private final ByteBuffer chunkHeader;
    private final DirectUnboundedByteSink chunkSink;
    private final ResponseHeaderBuffer hb;
    private final WritableByteChannel channel;
    private final SimpleResponse simple = new SimpleResponseImpl();
    private final ResponseSink sink = new ResponseSinkImpl();
    private final FixedSizeResponse fixedSize = new FixedSizeResponseImpl();
    private final ChunkedResponse chunkedResponse = new ChunkedResponseImpl();
    private final int sz;
    private long _wPtr;
    private ByteBuffer zout;
    private ByteBuffer _flushBuf;
    private int state;
    private long z_streamp = 0L;
    private boolean compressed = false;
    private long pzout;
    private int crc = 0;
    private long total = 0L;
    private boolean header = true;

    public Response(WritableByteChannel channel, ServerConfiguration configuration, MillisecondClock clock) {
        if (configuration.getHttpBufRespHeader() <= 0) {
            throw new IllegalArgumentException("headerBufferSize");
        }
        if (configuration.getHttpBufRespContent() <= 0) {
            throw new IllegalArgumentException("contentBufferSize");
        }
        this.channel = channel;
        this.sz = Numbers.ceilPow2(configuration.getHttpBufRespContent());
        this.out = ByteBuffer.allocateDirect(this.sz);
        this.hb = new ResponseHeaderBuffer(configuration.getHttpBufRespHeader(), clock);
        this.chunkHeader = ByteBuffer.allocateDirect(8 + 2 * "\r\n".length());
        this.chunkSink = new DirectUnboundedByteSink(ByteBuffers.getAddress(this.chunkHeader));
        this.chunkSink.put("\r\n");
        this.outPtr = this._wPtr = ByteBuffers.getAddress(this.out);
        this.limit = this.outPtr + (long)this.sz;
    }

    @Override
    public void clear() {
        this.out.clear();
        this.hb.clear();
        this._wPtr = this.outPtr;
        if (this.zout != null) {
            this.zout.clear();
        }
        this.resetZip();
    }

    @Override
    public void close() {
        ByteBuffers.release(this.out);
        ByteBuffers.release(this.chunkHeader);
        this.hb.close();
        ByteBuffers.release(this.zout);
        if (this.z_streamp != 0L) {
            Zip.deflateEnd(this.z_streamp);
            this.z_streamp = 0L;
        }
    }

    public int getCode() {
        return this.hb.getCode();
    }

    public void resume() throws DisconnectedChannelException, SlowWritableChannelException {
        this.machine0();
    }

    final ChunkedResponse asChunked() {
        return this.chunkedResponse;
    }

    final FixedSizeResponse asFixedSize() {
        return this.fixedSize;
    }

    final SimpleResponse asSimple() {
        return this.simple;
    }

    final ResponseSink asSink() {
        return this.sink;
    }

    private int deflate(boolean flush) throws DisconnectedChannelException {
        int ret;
        int availIn;
        int len;
        int sz = this.sz - 8;
        long p = this.pzout + 10L;
        do {
            if ((ret = Zip.deflate(this.z_streamp, p, sz, flush)) < 0) {
                LOG.error().$("ZLib error: ").$(ret).$();
                throw DisconnectedChannelException.INSTANCE;
            }
            len = sz - Zip.availOut(this.z_streamp);
            availIn = Zip.availIn(this.z_streamp);
        } while (len == 0 && availIn > 0);
        if (len == 0) {
            return 8;
        }
        if (len < 0) {
            throw ZLibException.INSTANCE;
        }
        if (this.header) {
            Unsafe.getUnsafe().copyMemory(Zip.gzipHeader, this.pzout, 10L);
            this.header = false;
            this.zout.position(0);
        } else {
            this.zout.position(10);
        }
        if (flush && ret == 1) {
            Unsafe.getUnsafe().putInt(p + (long)len, this.crc);
            Unsafe.getUnsafe().putInt(p + (long)len + 4L, (int)this.total);
            this.zout.limit(10 + len + 8);
        } else {
            this.zout.limit(10 + len);
        }
        this._flushBuf = this.prepareChunk(this.zout.remaining());
        return flush && ret == 1 ? 11 : 10;
    }

    private void flush(ByteBuffer buf) throws DisconnectedChannelException, SlowWritableChannelException {
        this._flushBuf = buf;
        ByteBuffers.copyNonBlocking(buf, this.channel, this.channel instanceof NonBlockingSecureSocketChannel ? 1 : 1000);
        buf.clear();
        this._flushBuf = null;
    }

    private void flushSingle(ByteBuffer buf) throws DisconnectedChannelException, SlowWritableChannelException {
        this.state = 8;
        this.flush(buf);
    }

    private void machine(ByteBuffer buf, int nextState) throws DisconnectedChannelException, SlowWritableChannelException {
        this._flushBuf = buf;
        this.state = nextState;
        this.machine0();
    }

    private void machine0() throws DisconnectedChannelException, SlowWritableChannelException {
        block13: while (true) {
            if (this._flushBuf != null) {
                this.flush(this._flushBuf);
            }
            switch (this.state) {
                case 4: {
                    if (this.compressed) {
                        this.prepareCompressedBody();
                        this.state = 5;
                        continue block13;
                    }
                    this._flushBuf = this.prepareBody();
                    this.state = 8;
                    continue block13;
                }
                case 5: {
                    this.state = this.deflate(false);
                    continue block13;
                }
                case 11: {
                    this._flushBuf = this.zout;
                    this.state = 7;
                    continue block13;
                }
                case 10: {
                    this._flushBuf = this.zout;
                    this.state = 8;
                    continue block13;
                }
                case 6: {
                    this._flushBuf = this.out;
                    this.state = 8;
                    continue block13;
                }
                case 1: {
                    this._flushBuf = this.prepareChunk((int)(this._wPtr - this.outPtr));
                    this.state = 2;
                    continue block13;
                }
                case 2: {
                    this._flushBuf = this.prepareBody();
                    this.state = 7;
                    continue block13;
                }
                case 7: {
                    this._flushBuf = this.prepareChunk(0);
                    this.state = 3;
                    continue block13;
                }
                case 3: {
                    this.sink.put("\r\n");
                    this._flushBuf = this.prepareBody();
                    this.state = 8;
                    continue block13;
                }
                case 9: {
                    this.state = this.deflate(true);
                    continue block13;
                }
                case 8: {
                    return;
                }
            }
        }
    }

    private ByteBuffer prepareBody() {
        this.out.limit((int)(this._wPtr - this.outPtr));
        this._wPtr = this.outPtr;
        return this.out;
    }

    private ByteBuffer prepareChunk(int len) {
        this.chunkSink.clear("\r\n".length());
        Numbers.appendHex(this.chunkSink, len);
        this.chunkSink.put("\r\n");
        this.chunkHeader.limit(this.chunkSink.length());
        return this.chunkHeader;
    }

    private void prepareCompressedBody() {
        if (this.z_streamp == 0L) {
            this.z_streamp = Zip.deflateInit();
            this.zout = ByteBuffer.allocateDirect(this.sz);
            this.pzout = ByteBuffers.getAddress(this.zout);
        }
        int r = (int)(this._wPtr - this.outPtr);
        Zip.setInput(this.z_streamp, this.outPtr, r);
        this.crc = Zip.crc32(this.crc, this.outPtr, r);
        this.total += (long)r;
        this._wPtr = this.outPtr;
    }

    private void resetZip() {
        if (this.z_streamp != 0L) {
            Zip.deflateReset(this.z_streamp);
        }
        this.crc = 0;
        this.total = 0L;
    }

    private class ChunkedResponseImpl
    extends ResponseSinkImpl
    implements ChunkedResponse {
        private long bookmark;

        private ChunkedResponseImpl() {
            this.bookmark = Response.this.outPtr;
        }

        @Override
        public void bookmark() {
            this.bookmark = Response.this._wPtr;
        }

        @Override
        public boolean resetToBookmark() {
            Response.this._wPtr = this.bookmark;
            return this.bookmark != Response.this.outPtr;
        }

        @Override
        public void setCompressed(boolean compressed) {
            Response.this.compressed = compressed;
        }

        @Override
        public void flush() throws IOException {
            this.sendChunk();
        }

        @Override
        public void status(int status, CharSequence contentType) {
            super.status(status, contentType);
            if (Response.this.compressed) {
                Response.this.hb.put("Content-Encoding: gzip").put("\r\n");
            }
        }

        @Override
        public ByteBuffer out() {
            return Response.this.out;
        }

        @Override
        public void done() throws DisconnectedChannelException, SlowWritableChannelException {
            if (Response.this.compressed) {
                Response.this.machine(null, 9);
            } else {
                Response.this.machine(null, 7);
            }
        }

        @Override
        public CharSink headers() {
            return Response.this.hb;
        }

        @Override
        public void sendChunk() throws DisconnectedChannelException, SlowWritableChannelException {
            if (Response.this.outPtr != Response.this._wPtr) {
                if (Response.this.compressed) {
                    Response.this.machine(null, 4);
                } else {
                    Response.this.machine(Response.this.prepareChunk((int)(Response.this._wPtr - Response.this.outPtr)), 4);
                }
            }
        }

        @Override
        public void sendHeader() throws DisconnectedChannelException, SlowWritableChannelException {
            Response.this.flushSingle(Response.this.hb.prepareBuffer());
        }
    }

    private class FixedSizeResponseImpl
    implements FixedSizeResponse {
        private FixedSizeResponseImpl() {
        }

        @Override
        public void done() throws DisconnectedChannelException, SlowWritableChannelException {
        }

        @Override
        public void status(int status, CharSequence contentType, long len) {
            Response.this.hb.status(status, contentType, len);
        }

        @Override
        public CharSink headers() {
            return Response.this.hb;
        }

        @Override
        public ByteBuffer out() {
            return Response.this.out;
        }

        @Override
        public void sendChunk() throws DisconnectedChannelException, SlowWritableChannelException {
            Response.this.flushSingle(Response.this.out);
        }

        @Override
        public void sendHeader() throws DisconnectedChannelException, SlowWritableChannelException {
            Response.this.flushSingle(Response.this.hb.prepareBuffer());
        }
    }

    private class ResponseSinkImpl
    extends AbstractCharSink
    implements ResponseSink {
        private ResponseSinkImpl() {
        }

        @Override
        public void flush() throws IOException {
            Response.this.machine(Response.this.hb.prepareBuffer(), 1);
        }

        @Override
        public CharSink put(CharSequence seq) {
            int len = seq.length();
            long p = Response.this._wPtr;
            if (p + (long)len >= Response.this.limit) {
                throw ResponseContentBufferTooSmallException.INSTANCE;
            }
            Chars.strcpy(seq, len, p);
            Response.this._wPtr = p + (long)len;
            return this;
        }

        @Override
        public CharSink put(char c) {
            if (Response.this._wPtr < Response.this.limit) {
                Unsafe.getUnsafe().putByte(Response.this._wPtr++, (byte)c);
                return this;
            }
            throw ResponseContentBufferTooSmallException.INSTANCE;
        }

        @Override
        public CharSink put(float value, int scale) {
            if (value == value) {
                return super.put(value, scale);
            }
            this.put("null");
            return this;
        }

        @Override
        public CharSink put(double value, int scale) {
            if (value == value) {
                return super.put(value, scale);
            }
            this.put("null");
            return this;
        }

        @Override
        protected void putUtf8Special(char c) {
            if (c < ' ') {
                this.escapeSpace(c);
            } else {
                switch (c) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        this.put('\\');
                    }
                }
                this.put(c);
            }
        }

        @Override
        public void status(int status, CharSequence contentType) {
            Response.this.hb.status(status, contentType, -1L);
        }

        private void escapeSpace(char c) {
            switch (c) {
                case '\b': {
                    this.put("\\b");
                    break;
                }
                case '\f': {
                    this.put("\\f");
                    break;
                }
                case '\n': {
                    this.put("\\n");
                    break;
                }
                case '\r': {
                    this.put("\\r");
                    break;
                }
                case '\t': {
                    this.put("\\t");
                    break;
                }
                default: {
                    this.put(c);
                }
            }
        }
    }

    private class SimpleResponseImpl
    implements SimpleResponse {
        private SimpleResponseImpl() {
        }

        @Override
        public void send(int code) throws DisconnectedChannelException, SlowWritableChannelException {
            this.send(code, null);
        }

        @Override
        public void send(int code, CharSequence message) throws DisconnectedChannelException, SlowWritableChannelException {
            LogRecord log = LOG.info().$("Sending ").$(code);
            if (message != null) {
                log.$(": ").$(message);
            }
            log.$();
            String std = Response.this.hb.status(code, "text/html; charset=utf-8", -1L);
            Response.this.sink.put(message == null ? std : message).put("\r\n");
            Response.this.machine(Response.this.hb.prepareBuffer(), 1);
        }

        @Override
        public void sendEmptyBody(int code) throws DisconnectedChannelException, SlowWritableChannelException {
            Response.this.hb.status(code, "text/html; charset=utf-8", -2L);
            Response.this.flushSingle(Response.this.hb.prepareBuffer());
        }
    }
}

