/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http;

import com.questdb.ex.ResponseHeaderBufferTooSmallException;
import com.questdb.std.ByteBuffers;
import com.questdb.std.Chars;
import com.questdb.std.IntObjHashMap;
import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.Unsafe;
import com.questdb.std.str.AbstractCharSink;
import com.questdb.std.str.CharSink;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.std.time.MillisecondClock;
import java.io.Closeable;
import java.nio.ByteBuffer;

public class ResponseHeaderBuffer
extends AbstractCharSink
implements Closeable,
Mutable {
    private static final IntObjHashMap<CharSequence> statusMap = new IntObjHashMap();
    private static final IntObjHashMap<String> httpStatusMap = new IntObjHashMap();
    private final long headerPtr;
    private final long limit;
    private final ByteBuffer headers;
    private final MillisecondClock clock;
    private long _wptr;
    private boolean chunky;
    private int code;

    public ResponseHeaderBuffer(int size, MillisecondClock clock) {
        this.clock = clock;
        int sz = Numbers.ceilPow2(size);
        this.headers = ByteBuffer.allocateDirect(sz);
        this.headerPtr = this._wptr = ByteBuffers.getAddress(this.headers);
        this.limit = this.headerPtr + (long)sz;
    }

    @Override
    public void clear() {
        this.headers.clear();
        this._wptr = this.headerPtr;
        this.chunky = false;
    }

    @Override
    public void close() {
        ByteBuffers.release(this.headers);
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public CharSink put(CharSequence cs) {
        long p = this._wptr;
        int len = cs.length();
        if (p + (long)len < this.limit) {
            Chars.strcpy(cs, len, p);
            this._wptr += (long)len;
        } else {
            throw ResponseHeaderBufferTooSmallException.INSTANCE;
        }
        return this;
    }

    @Override
    public CharSink put(char c) {
        if (this._wptr < this.limit) {
            Unsafe.getUnsafe().putByte(this._wptr++, (byte)c);
            return this;
        }
        throw ResponseHeaderBufferTooSmallException.INSTANCE;
    }

    public String status(int code, CharSequence contentType, long contentLength) {
        this.code = code;
        String status = httpStatusMap.get(code);
        if (status == null) {
            throw new IllegalArgumentException("Illegal status code: " + code);
        }
        this.put("HTTP/1.1 ").put(code).put(' ').put(status).put("\r\n");
        this.put("Server: ").put("questDB/1.0").put("\r\n");
        this.put("Date: ");
        DateFormatUtils.formatHTTP(this, this.clock.getTicks());
        this.put("\r\n");
        if (contentLength > -2L) {
            this.chunky = contentLength == -1L;
            if (this.chunky) {
                this.put("Transfer-Encoding: ").put("chunked").put("\r\n");
            } else {
                this.put("Content-Length: ").put(contentLength).put("\r\n");
            }
        }
        if (contentType != null) {
            this.put("Content-Type: ").put(contentType).put("\r\n");
        }
        return status;
    }

    ByteBuffer prepareBuffer() {
        if (!this.chunky) {
            this.put("\r\n");
        }
        this.headers.limit((int)(this._wptr - this.headerPtr));
        return this.headers;
    }

    static {
        httpStatusMap.put(200, "OK");
        httpStatusMap.put(206, "Partial content");
        httpStatusMap.put(304, "Not Modified");
        httpStatusMap.put(400, "Bad request");
        httpStatusMap.put(404, "Not Found");
        httpStatusMap.put(416, "Request range not satisfiable");
        httpStatusMap.put(431, "Headers too large");
        httpStatusMap.put(500, "Internal server error");
        statusMap.put(200, "OK");
    }
}

