/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http.handlers;

import com.questdb.net.http.ContextHandler;
import com.questdb.net.http.IOContext;
import com.questdb.net.http.MultipartListener;
import com.questdb.net.http.RequestHeaderBuffer;
import com.questdb.std.LocalValue;
import com.questdb.std.Mutable;
import com.questdb.std.str.ByteSequence;
import com.questdb.std.str.DirectByteCharSequence;
import java.io.Closeable;
import java.io.IOException;

public abstract class AbstractMultipartHandler
implements ContextHandler,
MultipartListener {
    private final LocalValue<MultipartContext> lvContext = new LocalValue();

    @Override
    public final void handle(IOContext context) throws IOException {
        this.onPartEnd(context);
        this.onComplete0(context);
    }

    @Override
    public void resume(IOContext context) throws IOException {
    }

    @Override
    public final void onChunk(IOContext context, RequestHeaderBuffer hb, DirectByteCharSequence data, boolean continued) throws IOException {
        if (!continued) {
            MultipartContext h = this.lvContext.get(context);
            if (h == null) {
                h = new MultipartContext();
                this.lvContext.set(context, h);
            }
            if (h.chunky) {
                this.onPartEnd(context);
            }
            h.chunky = true;
            this.onPartBegin(context, hb);
        }
        this.onData(context, data);
    }

    protected abstract void onComplete0(IOContext var1) throws IOException;

    protected abstract void onData(IOContext var1, ByteSequence var2) throws IOException;

    protected abstract void onPartBegin(IOContext var1, RequestHeaderBuffer var2) throws IOException;

    protected abstract void onPartEnd(IOContext var1) throws IOException;

    private static class MultipartContext
    implements Mutable,
    Closeable {
        private boolean chunky = false;

        private MultipartContext() {
        }

        @Override
        public void clear() {
            this.chunky = false;
        }

        @Override
        public void close() {
            this.clear();
        }
    }
}

