/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http.handlers;

import com.questdb.BootstrapEnv;
import com.questdb.common.JournalRuntimeException;
import com.questdb.common.NumericException;
import com.questdb.common.Record;
import com.questdb.common.RecordCursor;
import com.questdb.common.RecordMetadata;
import com.questdb.ex.ParserException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.log.LogRecord;
import com.questdb.net.http.ChunkedResponse;
import com.questdb.net.http.Request;
import com.questdb.parser.sql.QueryCompiler;
import com.questdb.parser.sql.QueryError;
import com.questdb.parser.sql.model.ParsedModel;
import com.questdb.ql.ChannelCheckCancellationHandler;
import com.questdb.ql.RecordSource;
import com.questdb.std.AssociativeCache;
import com.questdb.std.Chars;
import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.ex.DisconnectedChannelException;
import com.questdb.std.ex.JournalException;
import com.questdb.std.ex.SlowWritableChannelException;
import com.questdb.store.factory.Factory;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractQueryContext
implements Mutable,
Closeable {
    public static final int QUERY_PREFIX = 1;
    public static final int QUERY_METADATA = 2;
    public static final int QUERY_META_SUFFIX = 3;
    public static final int QUERY_RECORD_START = 4;
    public static final int QUERY_RECORD_COLUMNS = 5;
    public static final int QUERY_RECORD_SUFFIX = 6;
    public static final int QUERY_DATA_SUFFIX = 7;
    static final ThreadLocal<QueryCompiler> COMPILER = new ThreadLocal();
    static final ThreadLocal<AssociativeCache<RecordSource>> CACHE = new ThreadLocal();
    static final Log LOG = LogFactory.getLog(AbstractQueryContext.class);
    final ChannelCheckCancellationHandler cancellationHandler;
    final long fd;
    RecordSource recordSource;
    CharSequence query;
    RecordMetadata metadata;
    RecordCursor cursor;
    long count;
    long skip;
    long stop;
    Record record;
    int queryState = 1;
    int columnIndex;

    public AbstractQueryContext(long fd, int cyclesBeforeCancel) {
        this.cancellationHandler = new ChannelCheckCancellationHandler(fd, cyclesBeforeCancel);
        this.fd = fd;
    }

    @Override
    public void clear() {
        this.debug().$("Cleaning context").$();
        this.metadata = null;
        if (this.cursor != null) {
            this.cursor.releaseCursor();
            this.cursor = null;
        }
        this.record = null;
        if (this.recordSource != null) {
            CACHE.get().put(this.query.toString(), this.recordSource);
            this.recordSource = null;
        }
        this.query = null;
        this.queryState = 1;
        this.columnIndex = 0;
    }

    @Override
    public void close() throws IOException {
        this.debug().$("Closing context").$();
        this.clear();
    }

    public void compileQuery(ChunkedResponse r, Factory factory, AtomicLong misses, AtomicLong hits) throws IOException {
        try {
            this.recordSource = CACHE.get().poll(this.query);
            int retryCount = 0;
            while (true) {
                if (this.recordSource == null) {
                    this.recordSource = this.executeQuery(r, factory);
                    misses.incrementAndGet();
                } else {
                    hits.incrementAndGet();
                }
                if (this.recordSource == null) break;
                try {
                    this.cursor = this.recordSource.prepareCursor(factory, this.cancellationHandler);
                    this.metadata = this.recordSource.getMetadata();
                    this.header(r, 200);
                }
                catch (JournalRuntimeException e) {
                    if (retryCount == 0) {
                        CACHE.get().put(this.query.toString(), null);
                        this.recordSource = null;
                        LOG.error().$("RecordSource execution failed. ").$(e.getMessage()).$(". Retrying ...").$();
                        ++retryCount;
                        continue;
                    }
                    this.internalError(r, e);
                }
                break;
            }
            this.header(r, 200);
            this.sendConfirmation(r);
        }
        catch (ParserException e) {
            this.syntaxError(r);
        }
        catch (JournalRuntimeException e) {
            this.internalError(r, e);
        }
    }

    public boolean parseUrl(ChunkedResponse r, Request request) throws DisconnectedChannelException, SlowWritableChannelException {
        CharSequence query = request.getUrlParam("query");
        if (query == null || query.length() == 0) {
            this.info().$("Empty query request received. Sending empty reply.").$();
            this.sendException(r, 0, "No query text", 400);
            return false;
        }
        long skip = 0L;
        long stop = Long.MAX_VALUE;
        CharSequence limit = request.getUrlParam("limit");
        if (limit != null) {
            int sepPos = Chars.indexOf(limit, ',');
            try {
                if (sepPos > 0) {
                    skip = Numbers.parseLong(limit, 0, sepPos);
                    if (sepPos + 1 < limit.length()) {
                        stop = Numbers.parseLong(limit, sepPos + 1, limit.length());
                    }
                } else {
                    stop = Numbers.parseLong(limit);
                }
            }
            catch (NumericException numericException) {
                // empty catch block
            }
        }
        if (stop < 0L) {
            stop = 0L;
        }
        if (skip < 0L) {
            skip = 0L;
        }
        this.query = query;
        this.skip = skip;
        this.count = 0L;
        this.stop = stop;
        this.info().$("Query: ").$(query).$(", skip: ").$(skip).$(", stop: ").$(stop).$();
        return true;
    }

    static void setupThread(BootstrapEnv env) {
        if (COMPILER.get() == null) {
            COMPILER.set(new QueryCompiler(env));
        }
        if (CACHE.get() == null) {
            CACHE.set(new AssociativeCache(8, 128));
        }
    }

    LogRecord debug() {
        return LOG.debug().$('[').$(this.fd).$("] ");
    }

    LogRecord error() {
        return LOG.error().$('[').$(this.fd).$("] ");
    }

    private RecordSource executeQuery(ChunkedResponse r, Factory factory) throws ParserException, DisconnectedChannelException, SlowWritableChannelException {
        QueryCompiler compiler = COMPILER.get();
        ParsedModel model = compiler.parse(this.query);
        switch (model.getModelType()) {
            case 1: {
                return compiler.compile(factory, model);
            }
        }
        try {
            compiler.execute(factory, model);
        }
        catch (JournalException e) {
            this.error().$("Server error executing statement ").$(this.query).$(e).$();
            this.sendException(r, 0, e.getMessage(), 500);
        }
        return null;
    }

    protected abstract void header(ChunkedResponse var1, int var2) throws DisconnectedChannelException, SlowWritableChannelException;

    LogRecord info() {
        return LOG.info().$('[').$(this.fd).$("] ");
    }

    private void internalError(ChunkedResponse r, Throwable e) throws DisconnectedChannelException, SlowWritableChannelException {
        this.error().$("Server error executing query ").$(this.query).$(e).$();
        this.sendException(r, 0, e.getMessage(), 500);
    }

    private void sendConfirmation(ChunkedResponse r) throws DisconnectedChannelException, SlowWritableChannelException {
        r.put('{').putQuoted("ddl").put(':').putQuoted("OK").put('}');
        r.sendChunk();
        r.done();
    }

    protected abstract void sendException(ChunkedResponse var1, int var2, CharSequence var3, int var4) throws DisconnectedChannelException, SlowWritableChannelException;

    private void syntaxError(ChunkedResponse r) throws DisconnectedChannelException, SlowWritableChannelException {
        this.info().$("Parser error executing query ").$(this.query).$(": at (").$(QueryError.getPosition()).$(") ").$(QueryError.getMessage()).$();
        this.sendException(r, QueryError.getPosition(), QueryError.getMessage(), 400);
    }
}

