/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http.handlers;

import com.questdb.BootstrapEnv;
import com.questdb.common.Record;
import com.questdb.ex.ResponseContentBufferTooSmallException;
import com.questdb.net.http.ChunkedResponse;
import com.questdb.net.http.ContextHandler;
import com.questdb.net.http.IOContext;
import com.questdb.net.http.handlers.AbstractQueryContext;
import com.questdb.std.LocalValue;
import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.ex.DisconnectedChannelException;
import com.questdb.std.ex.SlowWritableChannelException;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.Factory;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class CsvHandler
implements ContextHandler {
    private final Factory factory;
    private final LocalValue<ExportHandlerContext> localContext = new LocalValue();
    private final AtomicLong cacheHits = new AtomicLong();
    private final AtomicLong cacheMisses = new AtomicLong();
    private final BootstrapEnv env;

    public CsvHandler(BootstrapEnv env) {
        this.factory = env.factory;
        this.env = env;
    }

    @Override
    public void handle(IOContext context) throws IOException {
        ChunkedResponse r;
        ExportHandlerContext ctx = this.localContext.get(context);
        if (ctx == null) {
            ctx = new ExportHandlerContext(context.getFd(), context.getServerConfiguration().getDbCyclesBeforeCancel());
            this.localContext.set(context, ctx);
        }
        if (ctx.parseUrl(r = context.chunkedResponse(), context.request)) {
            ctx.compileQuery(r, this.factory, this.cacheMisses, this.cacheHits);
            this.resume(context);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void resume(IOContext context) throws IOException {
        ctx = this.localContext.get(context);
        if (ctx == null || ctx.cursor == null) {
            return;
        }
        r = context.chunkedResponse();
        columnCount = ctx.metadata.getColumnCount();
        block8: while (true) {
            try {
                switch (ctx.queryState) {
                    case 2: {
                        while (ctx.columnIndex < columnCount) {
                            column = ctx.metadata.getColumnQuick(ctx.columnIndex);
                            r.bookmark();
                            if (ctx.columnIndex > 0) {
                                r.put(',');
                            }
                            r.putQuoted(column.getName());
                            ++ctx.columnIndex;
                        }
                        r.put("\r\n");
                        ctx.queryState = 4;
                    }
                    case 4: {
                        if (ctx.record != null) ** GOTO lbl34
                        while (ctx.cursor.hasNext()) {
                            ctx.record = (Record)ctx.cursor.next();
                            ++ctx.count;
                            if (ctx.count <= ctx.skip) continue;
                            ** GOTO lbl34
                        }
                        ctx.cursor.releaseCursor();
                        ctx.cursor = null;
                        ctx.queryState = 7;
                        continue block8;
lbl34:
                        // 2 sources

                        if (ctx.count > ctx.stop) {
                            ctx.queryState = 7;
                            continue block8;
                        }
                        ctx.queryState = 5;
                        ctx.columnIndex = 0;
                    }
                    case 5: {
                        while (ctx.columnIndex < columnCount) {
                            m = ctx.metadata.getColumnQuick(ctx.columnIndex);
                            r.bookmark();
                            if (ctx.columnIndex > 0) {
                                r.put(',');
                            }
                            CsvHandler.putValue(r, m.getType(), ctx.record, ctx.columnIndex);
                            ++ctx.columnIndex;
                        }
                        r.bookmark();
                        r.put("\r\n");
                        ctx.record = null;
                        ctx.queryState = 4;
                        continue block8;
                    }
                    case 7: {
                        this.sendDone(r, ctx);
                        break;
                    }
                }
            }
            catch (ResponseContentBufferTooSmallException ignored) {
                if (r.resetToBookmark()) {
                    r.sendChunk();
                    continue;
                }
                ctx.info().$("Response buffer is too small, state=").$(ctx.queryState).$();
                throw DisconnectedChannelException.INSTANCE;
            }
            break;
        }
    }

    @Override
    public void setupThread() {
        AbstractQueryContext.setupThread(this.env);
    }

    private static void putValue(CharSink sink, int type, Record rec, int col) {
        switch (type) {
            case 0: {
                sink.put(rec.getBool(col));
                break;
            }
            case 1: {
                sink.put(rec.get(col));
                break;
            }
            case 2: {
                double d = rec.getDouble(col);
                if (d != d) break;
                sink.put(d, 10);
                break;
            }
            case 3: {
                float f = rec.getFloat(col);
                if (f != f) break;
                sink.put(f, 10);
                break;
            }
            case 4: {
                int i = rec.getInt(col);
                if (i <= Integer.MIN_VALUE) break;
                Numbers.append(sink, i);
                break;
            }
            case 5: {
                long l = rec.getLong(col);
                if (l <= Long.MIN_VALUE) break;
                sink.put(l);
                break;
            }
            case 10: {
                long dt = rec.getDate(col);
                if (dt <= Long.MIN_VALUE) break;
                sink.put('\"').putISODateMillis(dt).put('\"');
                break;
            }
            case 6: {
                sink.put(rec.getShort(col));
                break;
            }
            case 7: {
                CharSequence cs = rec.getFlyweightStr(col);
                if (cs == null) break;
                sink.put(cs);
                break;
            }
            case 8: {
                CharSequence cs = rec.getSym(col);
                if (cs == null) break;
                sink.put(cs);
                break;
            }
            case 9: {
                break;
            }
        }
    }

    private void sendDone(ChunkedResponse r, ExportHandlerContext ctx) throws DisconnectedChannelException, SlowWritableChannelException {
        if (ctx.count > -1L) {
            ctx.count = -1L;
            r.sendChunk();
        }
        r.done();
    }

    private static class ExportHandlerContext
    extends AbstractQueryContext
    implements Mutable,
    Closeable {
        public ExportHandlerContext(long fd, int cyclesBeforeCancel) {
            super(fd, cyclesBeforeCancel);
            this.queryState = 2;
        }

        @Override
        public void clear() {
            super.clear();
            this.queryState = 2;
        }

        @Override
        public void close() throws IOException {
            this.debug().$("Closing context").$();
            this.clear();
        }

        @Override
        protected void header(ChunkedResponse r, int code) throws DisconnectedChannelException, SlowWritableChannelException {
            this.queryState = 2;
            r.status(code, "text/csv; charset=utf-8");
            r.headers().put("Content-Disposition: attachment; filename=\"questdb-query-").put(System.currentTimeMillis()).put(".csv\"").put("\r\n");
            r.sendHeader();
        }

        @Override
        protected void sendException(ChunkedResponse r, int position, CharSequence message, int status) throws DisconnectedChannelException, SlowWritableChannelException {
            this.header(r, status);
            r.put("Error at(").put(position).put("): ").put(message).put("\r\n");
            r.sendChunk();
            r.done();
        }
    }
}

