/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http.handlers;

import com.questdb.BootstrapEnv;
import com.questdb.net.http.ContextHandler;
import com.questdb.net.http.IOContext;
import com.questdb.net.http.ResponseSink;
import com.questdb.std.Chars;
import com.questdb.store.factory.configuration.JournalConfiguration;
import java.io.IOException;

public class ExistenceCheckHandler
implements ContextHandler {
    private final JournalConfiguration configuration;

    public ExistenceCheckHandler(BootstrapEnv env) {
        this.configuration = env.factory.getConfiguration();
    }

    @Override
    public void handle(IOContext context) throws IOException {
        CharSequence journalName = context.request.getUrlParam("j");
        if (journalName == null) {
            context.simpleResponse().send(400);
        } else {
            int check = this.configuration.exists(journalName);
            if (Chars.equalsNc("json", context.request.getUrlParam("f"))) {
                ResponseSink r = context.responseSink();
                r.status(200, "application/json");
                r.put('{').putQuoted("status").put(':').putQuoted(ExistenceCheckHandler.toResponse(check)).put('}');
                r.flush();
            } else {
                context.simpleResponse().send(200, ExistenceCheckHandler.toResponse(check));
            }
        }
    }

    @Override
    public void resume(IOContext context) throws IOException {
    }

    @Override
    public void setupThread() {
    }

    private static String toResponse(int existenceCheckResult) {
        switch (existenceCheckResult) {
            case 1: {
                return "Exists";
            }
            case 2: {
                return "Does not exist";
            }
            case 4: {
                return "Reserved name";
            }
        }
        return "Unknown";
    }
}

