/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http.handlers;

import com.questdb.BootstrapEnv;
import com.questdb.common.ColumnType;
import com.questdb.common.JournalRuntimeException;
import com.questdb.common.PartitionBy;
import com.questdb.ex.ImportSchemaException;
import com.questdb.ex.ResponseContentBufferTooSmallException;
import com.questdb.net.http.ChunkedResponse;
import com.questdb.net.http.IOContext;
import com.questdb.net.http.RequestHeaderBuffer;
import com.questdb.net.http.ResponseSink;
import com.questdb.net.http.handlers.AbstractMultipartHandler;
import com.questdb.parser.ImportedColumnMetadata;
import com.questdb.parser.JsonSchemaParser;
import com.questdb.parser.json.JsonException;
import com.questdb.parser.json.JsonLexer;
import com.questdb.parser.plaintext.PlainTextDelimiterLexer;
import com.questdb.parser.plaintext.PlainTextLexer;
import com.questdb.parser.plaintext.PlainTextStoringParser;
import com.questdb.std.CharSequenceIntHashMap;
import com.questdb.std.Chars;
import com.questdb.std.LocalValue;
import com.questdb.std.LongList;
import com.questdb.std.Misc;
import com.questdb.std.Mutable;
import com.questdb.std.ObjList;
import com.questdb.std.ex.DisconnectedChannelException;
import com.questdb.std.ex.SlowWritableChannelException;
import com.questdb.std.str.ByteSequence;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.DirectByteCharSequence;
import com.questdb.std.str.FileNameExtractorCharSequence;
import com.questdb.store.factory.configuration.ColumnMetadata;
import com.questdb.store.factory.configuration.JournalMetadata;
import java.io.Closeable;
import java.io.IOException;

public class ImportHandler
extends AbstractMultipartHandler {
    private static final int RESPONSE_PREFIX = 1;
    private static final int RESPONSE_COLUMN = 2;
    private static final int RESPONSE_SUFFIX = 3;
    private static final int MESSAGE_SCHEMA = 1;
    private static final int MESSAGE_DATA = 2;
    private static final int MESSAGE_UNKNOWN = 3;
    private static final int TO_STRING_COL1_PAD = 15;
    private static final int TO_STRING_COL2_PAD = 50;
    private static final int TO_STRING_COL3_PAD = 15;
    private static final int TO_STRING_COL4_PAD = 7;
    private static final int TO_STRING_COL5_PAD = 10;
    private static final CharSequence CONTENT_TYPE_TEXT = "text/plain; charset=utf-8";
    private static final CharSequence CONTENT_TYPE_JSON = "application/json; charset=utf-8";
    private static final ThreadLocal<PlainTextDelimiterLexer> PARSER = new ThreadLocal();
    private static final CharSequenceIntHashMap atomicityParamMap = new CharSequenceIntHashMap();
    private final LocalValue<ImportHandlerContext> lvContext = new LocalValue();
    private final BootstrapEnv env;

    public ImportHandler(BootstrapEnv env) {
        this.env = env;
    }

    @Override
    public void resume(IOContext context) throws IOException {
        super.resume(context);
        ImportHandlerContext ctx = this.lvContext.get(context);
        ChunkedResponse r = context.chunkedResponse();
        try {
            if (ctx.json) {
                ImportHandler.resumeJson(ctx, r);
            } else {
                ImportHandler.resumeText(ctx, r);
            }
        }
        catch (ResponseContentBufferTooSmallException ignored) {
            if (r.resetToBookmark()) {
                r.sendChunk();
            }
            throw DisconnectedChannelException.INSTANCE;
        }
        ctx.clear();
    }

    @Override
    protected void onComplete0(IOContext context) throws IOException {
    }

    @Override
    protected void onData(IOContext context, ByteSequence data) throws IOException {
        ImportHandlerContext h = this.lvContext.get(context);
        int len = data.length();
        if (len < 1) {
            return;
        }
        long lo = ((DirectByteCharSequence)data).getLo();
        switch (h.messagePart) {
            case 2: {
                if (h.state != 0) break;
                this.parseData(context, h, lo, len);
                break;
            }
            case 1: {
                this.parseSchema(context, h, lo, len);
                break;
            }
        }
    }

    @Override
    protected void onPartBegin(IOContext context, RequestHeaderBuffer hb) throws IOException {
        ImportHandlerContext h = this.lvContext.get(context);
        if (Chars.equals((CharSequence)"data", hb.getContentDispositionName())) {
            CharSequence name = context.request.getUrlParam("name");
            if (name == null) {
                name = hb.getContentDispositionFilename();
            }
            if (name == null) {
                context.simpleResponse().send(400, "no name given");
                throw DisconnectedChannelException.INSTANCE;
            }
            h.analysed = false;
            h.importer.of(FileNameExtractorCharSequence.get(name).toString(), Chars.equalsNc("true", context.request.getUrlParam("overwrite")), Chars.equalsNc("true", context.request.getUrlParam("durable")), ImportHandler.getAtomicity(context.request.getUrlParam("atomicity")));
            h.forceHeader = Chars.equalsNc("true", context.request.getUrlParam("forceHeader"));
            h.messagePart = 2;
        } else if (Chars.equals((CharSequence)"schema", hb.getContentDispositionName())) {
            h.messagePart = 1;
        } else {
            h.messagePart = 3;
        }
    }

    @Override
    protected void onPartEnd(IOContext context) throws IOException {
        ImportHandlerContext h = this.lvContext.get(context);
        if (h != null) {
            switch (h.messagePart) {
                case 2: {
                    h.textParser.parseLast();
                    h.importer.commit();
                    this.sendResponse(context);
                    break;
                }
                case 1: {
                    try {
                        h.jsonLexer.parseLast();
                    }
                    catch (JsonException e) {
                        this.handleJsonException(context, h, e);
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void setup(IOContext context) {
        ImportHandlerContext h = this.lvContext.get(context);
        if (h == null) {
            this.lvContext.set(context, new ImportHandlerContext(this.env));
        }
    }

    @Override
    public void setupThread() {
        PARSER.set(PlainTextDelimiterLexer.FACTORY.newInstance());
    }

    private static void resumeJson(ImportHandlerContext ctx, ChunkedResponse r) throws DisconnectedChannelException, SlowWritableChannelException {
        JournalMetadata m = ctx.importer.getJournalMetadata();
        ObjList<ImportedColumnMetadata> importedMetadata = ctx.importer.getImportedMetadata();
        int columnCount = m.getColumnCount();
        LongList errors = ctx.importer.getErrors();
        switch (ctx.responseState) {
            case 1: {
                long totalRows = ctx.textParser.getLineCount();
                long importedRows = ctx.importer.getImportedRowCount();
                r.put('{').putQuoted("status").put(':').putQuoted("OK").put(',').putQuoted("location").put(':').encodeUtf8AndQuote(FileNameExtractorCharSequence.get(m.getName())).put(',').putQuoted("rowsRejected").put(':').put(totalRows - importedRows).put(',').putQuoted("rowsImported").put(':').put(importedRows).put(',').putQuoted("header").put(':').put(ctx.importer.isHeader()).put(',').putQuoted("columns").put(':').put('[');
                ctx.responseState = 2;
            }
            case 2: {
                while (ctx.columnIndex < columnCount) {
                    ColumnMetadata cm = m.getColumnQuick(ctx.columnIndex);
                    ImportedColumnMetadata im = importedMetadata.getQuick(ctx.columnIndex);
                    r.bookmark();
                    if (ctx.columnIndex > 0) {
                        r.put(',');
                    }
                    r.put('{').putQuoted("name").put(':').putQuoted(cm.getName()).put(',').putQuoted("type").put(':').putQuoted(ColumnType.nameOf(cm.getType())).put(',').putQuoted("size").put(':').put(ColumnType.sizeOf(cm.getType())).put(',').putQuoted("errors").put(':').put(errors.getQuick(ctx.columnIndex));
                    if (im.pattern != null) {
                        r.put(',').putQuoted("pattern").put(':').putQuoted(im.pattern);
                    }
                    if (im.dateLocale != null) {
                        r.put(',').putQuoted("locale").put(':').putQuoted(im.dateLocale.getId());
                    }
                    r.put('}');
                    ++ctx.columnIndex;
                }
                ctx.responseState = 3;
            }
            case 3: {
                r.bookmark();
                r.put(']').put('}');
                r.sendChunk();
                r.done();
                break;
            }
        }
    }

    private static CharSink pad(CharSink b, int w, CharSequence value) {
        int pad = value == null ? w : w - value.length();
        ImportHandler.replicate(b, ' ', pad);
        if (value != null) {
            if (pad < 0) {
                b.put("...").put(value.subSequence(-pad + 3, value.length()));
            } else {
                b.put(value);
            }
        }
        b.put("  |");
        return b;
    }

    private static void pad(CharSink b, int w, long value) {
        int len = (int)Math.log10(value);
        if (len < 0) {
            len = 0;
        }
        ImportHandler.replicate(b, ' ', w - len - 1);
        b.put(value);
        b.put("  |");
    }

    private static void replicate(CharSink b, char c, int times) {
        for (int i = 0; i < times; ++i) {
            b.put(c);
        }
    }

    private static void sep(CharSink b) {
        b.put('+');
        ImportHandler.replicate(b, '-', 111);
        b.put("+\n");
    }

    private static void col(CharSink b, ColumnMetadata m, ImportedColumnMetadata im) {
        ImportHandler.pad(b, 50, (m.distinctCountHint > 0 ? m.distinctCountHint + " ~ " : "") + (m.indexed ? Character.valueOf('#') : "") + m.name + (m.sameAs != null ? " -> " + m.sameAs : "") + ' ' + ColumnType.nameOf(m.type) + '(' + m.size + ')');
        ImportHandler.pad(b, 15, im.pattern);
        ImportHandler.pad(b, 7, im.dateLocale != null ? im.dateLocale.getId() : null);
    }

    private static void resumeText(ImportHandlerContext h, ChunkedResponse r) throws IOException {
        JournalMetadata m = h.importer.getJournalMetadata();
        LongList errors = h.importer.getErrors();
        ObjList<ImportedColumnMetadata> importedMetadata = h.importer.getImportedMetadata();
        int columnCount = m.getColumnCount();
        switch (h.responseState) {
            case 1: {
                ImportHandler.sep(r);
                r.put('|');
                ImportHandler.pad((CharSink)r, 15, "Location:");
                ImportHandler.pad((CharSink)r, 50, m.getName());
                ImportHandler.pad((CharSink)r, 15, "Pattern");
                ImportHandler.pad((CharSink)r, 7, "Locale");
                ImportHandler.pad((CharSink)r, 10, "Errors").put("\r\n");
                r.put('|');
                ImportHandler.pad((CharSink)r, 15, "Partition by");
                ImportHandler.pad((CharSink)r, 50, PartitionBy.toString(m.getPartitionBy()));
                ImportHandler.pad((CharSink)r, 15, "");
                ImportHandler.pad((CharSink)r, 7, "");
                ImportHandler.pad((CharSink)r, 10, "").put("\r\n");
                ImportHandler.sep(r);
                r.put('|');
                ImportHandler.pad((CharSink)r, 15, "Rows handled");
                ImportHandler.pad((CharSink)r, 50, h.textParser.getLineCount());
                ImportHandler.pad((CharSink)r, 15, "");
                ImportHandler.pad((CharSink)r, 7, "");
                ImportHandler.pad((CharSink)r, 10, "").put("\r\n");
                r.put('|');
                ImportHandler.pad((CharSink)r, 15, "Rows imported");
                ImportHandler.pad((CharSink)r, 50, h.importer.getImportedRowCount());
                ImportHandler.pad((CharSink)r, 15, "");
                ImportHandler.pad((CharSink)r, 7, "");
                ImportHandler.pad((CharSink)r, 10, "").put("\r\n");
                ImportHandler.sep(r);
                h.responseState = 2;
            }
            case 2: {
                while (h.columnIndex < columnCount) {
                    r.bookmark();
                    r.put('|');
                    ImportHandler.pad((CharSink)r, 15, h.columnIndex);
                    ImportHandler.col(r, m.getColumnQuick(h.columnIndex), importedMetadata.getQuick(h.columnIndex));
                    ImportHandler.pad((CharSink)r, 10, errors.getQuick(h.columnIndex));
                    r.put("\r\n");
                    ++h.columnIndex;
                }
                h.responseState = 3;
            }
            case 3: {
                r.bookmark();
                ImportHandler.sep(r);
                r.sendChunk();
                r.done();
                break;
            }
        }
    }

    private static int getAtomicity(CharSequence name) {
        if (name == null) {
            return 1;
        }
        int atomicity = atomicityParamMap.get(name);
        return atomicity == -1 ? 1 : atomicity;
    }

    private void analyseFormat(ImportHandlerContext context, long address, int len) {
        PlainTextDelimiterLexer plainTextDelimiterLexer = PARSER.get();
        plainTextDelimiterLexer.of(address, len);
        if (plainTextDelimiterLexer.getDelimiter() != '\u0000' && plainTextDelimiterLexer.getStdDev() < 0.5) {
            context.state = 0;
            context.textParser.of(plainTextDelimiterLexer.getDelimiter());
        } else {
            context.state = 1;
            context.stateMessage = "Unsupported Data Format";
        }
    }

    private void handleJsonException(IOContext context, ImportHandlerContext h, JsonException e) throws IOException {
        if (this.env.configuration.isHttpAbortBrokenUploads()) {
            this.sendError(context, e.getMessage());
            throw ImportSchemaException.INSTANCE;
        }
        h.state = 2;
        h.stateMessage = e.getMessage();
    }

    private void parseData(IOContext context, ImportHandlerContext h, long lo, int len) throws IOException {
        if (h.analysed) {
            h.textParser.parse(lo, len, Integer.MAX_VALUE, h.importer);
        } else {
            this.analyseFormat(h, lo, len);
            if (h.state == 0) {
                try {
                    h.textParser.analyseStructure(lo, len, this.env.configuration.getHttpImportSampleSize(), h.importer, h.forceHeader, h.jsonSchemaParser.getMetadata());
                    h.textParser.parse(lo, len, Integer.MAX_VALUE, h.importer);
                }
                catch (JournalRuntimeException e) {
                    if (this.env.configuration.isHttpAbortBrokenUploads()) {
                        this.sendError(context, e.getMessage());
                        throw e;
                    }
                    h.state = 2;
                    h.stateMessage = e.getMessage();
                }
            }
            h.analysed = true;
        }
    }

    private void parseSchema(IOContext context, ImportHandlerContext h, long lo, int len) throws IOException {
        try {
            h.jsonLexer.parse(lo, len, h.jsonSchemaParser);
        }
        catch (JsonException e) {
            this.handleJsonException(context, h, e);
        }
    }

    private void sendError(IOContext context, String message) throws IOException {
        ResponseSink sink = context.responseSink();
        if (Chars.equalsNc("json", context.request.getUrlParam("fmt"))) {
            sink.status(200, CONTENT_TYPE_JSON);
            sink.put('{').putQuoted("status").put(':').encodeUtf8AndQuote(message).put('}');
        } else {
            sink.status(400, CONTENT_TYPE_TEXT);
            sink.encodeUtf8(message);
        }
        sink.flush();
        throw DisconnectedChannelException.INSTANCE;
    }

    private void sendResponse(IOContext context) throws IOException {
        ImportHandlerContext h = this.lvContext.get(context);
        h.json = Chars.equalsNc("json", context.request.getUrlParam("fmt"));
        ChunkedResponse r = context.chunkedResponse();
        switch (h.state) {
            case 0: {
                if (h.json) {
                    r.status(200, CONTENT_TYPE_JSON);
                } else {
                    r.status(200, CONTENT_TYPE_TEXT);
                }
                r.sendHeader();
                this.resume(context);
                break;
            }
            default: {
                this.sendError(context, h.stateMessage);
            }
        }
    }

    static {
        atomicityParamMap.put("relaxed", 1);
        atomicityParamMap.put("strict", 0);
    }

    private static class ImportHandlerContext
    implements Mutable,
    Closeable {
        public static final int STATE_OK = 0;
        public static final int STATE_INVALID_FORMAT = 1;
        public static final int STATE_DATA_ERROR = 2;
        private final PlainTextLexer textParser;
        private final PlainTextStoringParser importer;
        private final JsonSchemaParser jsonSchemaParser;
        private final JsonLexer jsonLexer;
        public int columnIndex = 0;
        private int state;
        private String stateMessage;
        private boolean analysed = false;
        private int messagePart = 3;
        private int responseState = 1;
        private boolean json = false;
        private boolean forceHeader = false;

        private ImportHandlerContext(BootstrapEnv env) {
            this.importer = new PlainTextStoringParser(env);
            this.textParser = new PlainTextLexer(env);
            this.jsonSchemaParser = new JsonSchemaParser(env);
            this.jsonLexer = new JsonLexer(env.configuration.getHttpImportMaxJsonStringLen());
        }

        @Override
        public void clear() {
            this.responseState = 1;
            this.columnIndex = 0;
            this.messagePart = 3;
            this.analysed = false;
            this.state = 0;
            this.textParser.clear();
            this.importer.clear();
            this.jsonLexer.clear();
            this.jsonSchemaParser.clear();
        }

        @Override
        public void close() {
            this.clear();
            Misc.free(this.textParser);
            Misc.free(this.importer);
            Misc.free(this.jsonLexer);
        }
    }
}

