/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http.handlers;

import com.questdb.BootstrapEnv;
import com.questdb.common.ColumnType;
import com.questdb.common.Record;
import com.questdb.ex.ResponseContentBufferTooSmallException;
import com.questdb.net.http.ChunkedResponse;
import com.questdb.net.http.ContextHandler;
import com.questdb.net.http.IOContext;
import com.questdb.net.http.ResponseSink;
import com.questdb.net.http.handlers.AbstractQueryContext;
import com.questdb.net.http.handlers.QueryHandlerContext;
import com.questdb.std.LocalValue;
import com.questdb.std.Numbers;
import com.questdb.std.ex.DisconnectedChannelException;
import com.questdb.std.ex.SlowWritableChannelException;
import com.questdb.std.str.CharSink;
import com.questdb.store.factory.Factory;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class QueryHandler
implements ContextHandler {
    private final Factory factory;
    private final LocalValue<QueryHandlerContext> localContext = new LocalValue();
    private final AtomicLong cacheHits = new AtomicLong();
    private final AtomicLong cacheMisses = new AtomicLong();
    private final BootstrapEnv env;

    public QueryHandler(BootstrapEnv env) {
        this.factory = env.factory;
        this.env = env;
    }

    @Override
    public void handle(IOContext context) throws IOException {
        ChunkedResponse r;
        QueryHandlerContext ctx = this.localContext.get(context);
        if (ctx == null) {
            ctx = new QueryHandlerContext(context.getFd(), context.getServerConfiguration().getDbCyclesBeforeCancel());
            this.localContext.set(context, ctx);
        }
        if (ctx.parseUrl(r = context.chunkedResponse(), context.request)) {
            ctx.compileQuery(r, this.factory, this.cacheMisses, this.cacheHits);
            this.resume(context);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void resume(IOContext context) throws IOException {
        ctx = this.localContext.get(context);
        if (ctx == null || ctx.cursor == null) {
            return;
        }
        r = context.chunkedResponse();
        columnCount = ctx.metadata.getColumnCount();
        block11: while (true) {
            try {
                switch (ctx.queryState) {
                    case 1: {
                        if (ctx.noMeta) {
                            r.put('{').putQuoted("dataset").put(":[");
                            ctx.queryState = 4;
                            continue block11;
                        }
                        r.bookmark();
                        r.put('{').putQuoted("query").put(':').encodeUtf8AndQuote(ctx.query);
                        r.put(',').putQuoted("columns").put(':').put('[');
                        ctx.queryState = 2;
                        ctx.columnIndex = 0;
                    }
                    case 2: {
                        while (ctx.columnIndex < columnCount) {
                            column = ctx.metadata.getColumnQuick(ctx.columnIndex);
                            r.bookmark();
                            if (ctx.columnIndex > 0) {
                                r.put(',');
                            }
                            r.put('{').putQuoted("name").put(':').putQuoted(column.getName()).put(',').putQuoted("type").put(':').putQuoted(ColumnType.nameOf(column.getType()));
                            r.put('}');
                            ++ctx.columnIndex;
                        }
                        ctx.queryState = 3;
                    }
                    case 3: {
                        r.bookmark();
                        r.put("],\"dataset\":[");
                        ctx.queryState = 4;
                    }
                    case 4: {
                        if (ctx.record != null) ** GOTO lbl53
                        while (ctx.cursor.hasNext()) {
                            ctx.record = (Record)ctx.cursor.next();
                            ++ctx.count;
                            if (ctx.fetchAll && ctx.count > ctx.stop) {
                                ctx.cancellationHandler.check();
                                continue;
                            }
                            if (ctx.count <= ctx.skip) continue;
                            ** GOTO lbl53
                        }
                        ctx.queryState = 7;
                        continue block11;
lbl53:
                        // 2 sources

                        if (ctx.count > ctx.stop) {
                            ctx.queryState = 7;
                            continue block11;
                        }
                        r.bookmark();
                        if (ctx.count > ctx.skip + 1L) {
                            r.put(',');
                        }
                        r.put('[');
                        ctx.queryState = 5;
                        ctx.columnIndex = 0;
                    }
                    case 5: {
                        while (ctx.columnIndex < columnCount) {
                            m = ctx.metadata.getColumnQuick(ctx.columnIndex);
                            r.bookmark();
                            if (ctx.columnIndex > 0) {
                                r.put(',');
                            }
                            QueryHandler.putValue(r, m.getType(), ctx.record, ctx.columnIndex);
                            ++ctx.columnIndex;
                        }
                        ctx.queryState = 6;
                    }
                    case 6: {
                        r.bookmark();
                        r.put(']');
                        ctx.record = null;
                        ctx.queryState = 4;
                        continue block11;
                    }
                    case 7: {
                        this.sendDone(r, ctx);
                        break;
                    }
                }
            }
            catch (ResponseContentBufferTooSmallException ignored) {
                if (r.resetToBookmark()) {
                    r.sendChunk();
                    continue;
                }
                ctx.info().$("Response buffer is too small, state=").$(ctx.queryState).$();
                throw DisconnectedChannelException.INSTANCE;
            }
            break;
        }
    }

    @Override
    public void setupThread() {
        AbstractQueryContext.setupThread(this.env);
    }

    private static void putValue(ResponseSink sink, int type, Record rec, int col) {
        switch (type) {
            case 0: {
                sink.put(rec.getBool(col));
                break;
            }
            case 1: {
                sink.put(rec.get(col));
                break;
            }
            case 2: {
                sink.put(rec.getDouble(col), 10);
                break;
            }
            case 3: {
                sink.put(rec.getFloat(col), 10);
                break;
            }
            case 4: {
                int i = rec.getInt(col);
                if (i == Integer.MIN_VALUE) {
                    sink.put("null");
                    break;
                }
                Numbers.append((CharSink)sink, i);
                break;
            }
            case 5: {
                long l = rec.getLong(col);
                if (l == Long.MIN_VALUE) {
                    sink.put("null");
                    break;
                }
                sink.put(l);
                break;
            }
            case 10: {
                long d = rec.getDate(col);
                if (d == Long.MIN_VALUE) {
                    sink.put("null");
                    break;
                }
                sink.put('\"').putISODateMillis(d).put('\"');
                break;
            }
            case 6: {
                sink.put(rec.getShort(col));
                break;
            }
            case 7: {
                QueryHandler.putStringOrNull(sink, rec.getFlyweightStr(col));
                break;
            }
            case 8: {
                QueryHandler.putStringOrNull(sink, rec.getSym(col));
                break;
            }
            case 9: {
                sink.put('[');
                sink.put(']');
                break;
            }
        }
    }

    private static void putStringOrNull(CharSink r, CharSequence str) {
        if (str == null) {
            r.put("null");
        } else {
            r.encodeUtf8AndQuote(str);
        }
    }

    long getCacheHits() {
        return this.cacheHits.longValue();
    }

    long getCacheMisses() {
        return this.cacheMisses.longValue();
    }

    private void sendDone(ChunkedResponse r, QueryHandlerContext ctx) throws DisconnectedChannelException, SlowWritableChannelException {
        if (ctx.count > -1L) {
            r.bookmark();
            r.put(']');
            r.put(',').putQuoted("count").put(':').put(ctx.count);
            r.put('}');
            ctx.count = -1L;
            r.sendChunk();
        }
        r.done();
    }
}

