/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http.handlers;

import com.questdb.net.http.ChunkedResponse;
import com.questdb.net.http.Request;
import com.questdb.net.http.handlers.AbstractQueryContext;
import com.questdb.std.Chars;
import com.questdb.std.ex.DisconnectedChannelException;
import com.questdb.std.ex.SlowWritableChannelException;

public class QueryHandlerContext
extends AbstractQueryContext {
    boolean fetchAll = false;
    boolean noMeta = false;

    public QueryHandlerContext(long fd, int cyclesBeforeCancel) {
        super(fd, cyclesBeforeCancel);
    }

    @Override
    public void clear() {
        super.clear();
        this.queryState = 1;
        this.fetchAll = false;
    }

    @Override
    public boolean parseUrl(ChunkedResponse r, Request request) throws DisconnectedChannelException, SlowWritableChannelException {
        if (super.parseUrl(r, request)) {
            this.noMeta = Chars.equalsNc("true", request.getUrlParam("nm"));
            this.fetchAll = Chars.equalsNc("true", request.getUrlParam("count"));
            return true;
        }
        return false;
    }

    @Override
    protected void header(ChunkedResponse r, int status) throws DisconnectedChannelException, SlowWritableChannelException {
        r.status(status, "application/json; charset=utf-8");
        r.sendHeader();
    }

    @Override
    protected void sendException(ChunkedResponse r, int position, CharSequence message, int status) throws DisconnectedChannelException, SlowWritableChannelException {
        this.header(r, status);
        r.put('{').putQuoted("query").put(':').encodeUtf8AndQuote(this.query == null ? "" : this.query).put(',').putQuoted("error").put(':').encodeUtf8AndQuote(message).put(',').putQuoted("position").put(':').put(position);
        r.put('}');
        r.sendChunk();
        r.done();
    }
}

