/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http.handlers;

import com.questdb.BootstrapEnv;
import com.questdb.ServerConfiguration;
import com.questdb.common.NumericException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.net.http.ContextHandler;
import com.questdb.net.http.FixedSizeResponse;
import com.questdb.net.http.IOContext;
import com.questdb.net.http.MimeTypes;
import com.questdb.net.http.RangeParser;
import com.questdb.std.ByteBuffers;
import com.questdb.std.Chars;
import com.questdb.std.Files;
import com.questdb.std.LocalValue;
import com.questdb.std.Mutable;
import com.questdb.std.Numbers;
import com.questdb.std.Os;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.FileNameExtractorCharSequence;
import com.questdb.std.str.FlyweightCharSequence;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.PrefixedPath;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;

public class StaticContentHandler
implements ContextHandler {
    private static final Log LOG = LogFactory.getLog(StaticContentHandler.class);
    private final MimeTypes mimeTypes;
    private final ThreadLocal<PrefixedPath> tlPrefixedPath = new ThreadLocal();
    private final ThreadLocal<RangeParser> tlRangeParser = new ThreadLocal();
    private final ThreadLocal<FlyweightCharSequence> tlExt = new ThreadLocal();
    private final LocalValue<FileDescriptorHolder> lvFd = new LocalValue();
    private final ServerConfiguration configuration;

    public StaticContentHandler(BootstrapEnv env) throws IOException {
        this.configuration = env.configuration;
        this.mimeTypes = new MimeTypes(this.configuration.getMimeTypes());
    }

    @Override
    public void handle(IOContext context) throws IOException {
        CharSequence url = context.request.getUrl();
        LOG.info().$("handling static: ").$(url).$();
        if (Chars.contains(url, "..")) {
            LOG.info().$("URL abuse: ").$(url).$();
            context.simpleResponse().send(404);
        } else {
            PrefixedPath path = this.tlPrefixedPath.get().rewind();
            if (Chars.equals(url, '/')) {
                path.concat(this.configuration.getHttpIndexFile());
            } else {
                path.concat(url);
            }
            path.$();
            if (Files.exists(path)) {
                this.send(context, path, context.request.getUrlParam("attachment") != null);
            } else {
                LOG.info().$("Not found: ").$(path).$();
                context.simpleResponse().send(404);
            }
        }
    }

    @Override
    public void resume(IOContext context) throws IOException {
        long l;
        FileDescriptorHolder h = this.lvFd.get(context);
        if (h == null || h.fd == -1L) {
            return;
        }
        FixedSizeResponse r = context.fixedSizeResponse();
        ByteBuffer out = r.out();
        long wptr = ByteBuffers.getAddress(out);
        int sz = out.remaining();
        while (h.bytesSent < h.sendMax && (l = Files.read(h.fd, wptr, sz, h.bytesSent)) > 0L) {
            if (l + h.bytesSent > h.sendMax) {
                l = h.sendMax - h.bytesSent;
            }
            out.limit((int)l);
            h.bytesSent += l;
            r.sendChunk();
        }
        r.done();
        h.clear();
    }

    @Override
    public void setupThread() {
        this.tlRangeParser.set(RangeParser.FACTORY.newInstance());
        this.tlPrefixedPath.set(new PrefixedPath(this.configuration.getHttpPublic().getAbsolutePath()));
        this.tlExt.set(new FlyweightCharSequence());
    }

    private void send(IOContext context, LPSZ path, boolean asAttachment) throws IOException {
        int l;
        int n = Chars.lastIndexOf(path, '.');
        if (n == -1) {
            LOG.info().$("Missing extension: ").$(path).$();
            context.simpleResponse().send(404);
            return;
        }
        CharSequence contentType = (CharSequence)this.mimeTypes.get(this.tlExt.get().of(path, n + 1, path.length() - n - 1));
        CharSequence val = context.request.getHeader("Range");
        if (val != null) {
            this.sendRange(context, val, path, contentType, asAttachment);
            return;
        }
        val = context.request.getHeader("If-None-Match");
        if (val != null && (l = val.length()) > 2 && val.charAt(0) == '\"' && val.charAt(l - 1) == '\"') {
            try {
                long that = Numbers.parseLong(val, 1, l - 1);
                if (that == Files.getLastModified(path)) {
                    context.simpleResponse().sendEmptyBody(304);
                    return;
                }
            }
            catch (NumericException e) {
                LOG.info().$("Received wrong tag [").$(val).$("] for ").$(path).$();
                context.simpleResponse().send(400);
                return;
            }
        }
        this.sendVanilla(context, path, contentType, asAttachment);
    }

    private void sendRange(IOContext context, CharSequence range, LPSZ path, CharSequence contentType, boolean asAttachment) throws IOException {
        RangeParser rangeParser = this.tlRangeParser.get();
        if (rangeParser.of(range)) {
            FileDescriptorHolder h = this.lvFd.get(context);
            if (h == null) {
                h = new FileDescriptorHolder();
                this.lvFd.set(context, h);
            }
            h.fd = Files.openRO(path);
            if (h.fd == -1L) {
                LOG.info().$("Cannot open file: ").$(path).$();
                context.simpleResponse().send(404);
                return;
            }
            h.bytesSent = 0L;
            long length = Files.length(path);
            long lo = rangeParser.getLo();
            long hi = rangeParser.getHi();
            if (lo > length || hi != Long.MAX_VALUE && hi > length || lo > hi) {
                context.simpleResponse().send(416);
            } else {
                h.bytesSent = lo;
                h.sendMax = hi == Long.MAX_VALUE ? length : hi;
                FixedSizeResponse r = context.fixedSizeResponse();
                r.status(206, contentType, h.sendMax - lo);
                CharSink sink = r.headers();
                if (asAttachment) {
                    sink.put("Content-Disposition: attachment; filename=\"").put(FileNameExtractorCharSequence.get(path)).put('\"').put("\r\n");
                }
                sink.put("Accept-Ranges: bytes").put("\r\n");
                sink.put("Content-Range: bytes ").put(lo).put('-').put(h.sendMax).put('/').put(length).put("\r\n");
                sink.put("ETag: ").put(Files.getLastModified(path)).put("\r\n");
                r.sendHeader();
                this.resume(context);
            }
        } else {
            context.simpleResponse().send(416);
        }
    }

    private void sendVanilla(IOContext context, LPSZ path, CharSequence contentType, boolean asAttachment) throws IOException {
        long fd = Files.openRO(path);
        if (fd == -1L) {
            LOG.info().$("Cannot open file: ").$(path).$('(').$(Os.errno()).$(')').$();
            context.simpleResponse().send(404);
        } else {
            FileDescriptorHolder h = this.lvFd.get(context);
            if (h == null) {
                h = new FileDescriptorHolder();
                this.lvFd.set(context, h);
            }
            h.fd = fd;
            h.bytesSent = 0L;
            long length = Files.length(path);
            h.sendMax = Long.MAX_VALUE;
            FixedSizeResponse r = context.fixedSizeResponse();
            r.status(200, contentType, length);
            if (asAttachment) {
                r.headers().put("Content-Disposition: attachment; filename=\"").put(FileNameExtractorCharSequence.get(path)).put("\"").put("\r\n");
            }
            r.headers().put("ETag: ").put('\"').put(Files.getLastModified(path)).put('\"').put("\r\n");
            r.sendHeader();
            this.resume(context);
        }
    }

    private static class FileDescriptorHolder
    implements Mutable,
    Closeable {
        long fd = -1L;
        long bytesSent;
        long sendMax;

        private FileDescriptorHolder() {
        }

        @Override
        public void clear() {
            if (this.fd > -1L) {
                Files.close(this.fd);
                this.fd = -1L;
            }
            this.bytesSent = 0L;
            this.sendMax = Long.MAX_VALUE;
        }

        @Override
        public void close() {
            this.clear();
        }
    }
}

